/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.domain.Type;
import org.hibernate.metamodel.source.MappingDefaults;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBindingContextImpl
implements AnnotationBindingContext {
    private final MetadataImplementor metadata;
    private final ValueHolder<ClassLoaderService> classLoaderService;
    private final Index index;
    private final TypeResolver typeResolver = new TypeResolver();
    private final Map<Class<?>, ResolvedType> resolvedTypeCache = new HashMap();
    private Map<String, Type> nameToJavaTypeMap = new HashMap<String, Type>();

    public AnnotationBindingContextImpl(MetadataImplementor metadataImplementor, Index index) {
        this.metadata = metadataImplementor;
        this.classLoaderService = new ValueHolder<1>(new ValueHolder.DeferredInitializer<ClassLoaderService>(){

            @Override
            public ClassLoaderService initialize() {
                return AnnotationBindingContextImpl.this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
            }
        });
        this.index = index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public ClassInfo getClassInfo(String string) {
        DotName dotName = DotName.createSimple((String)string);
        return this.index.getClassByName(dotName);
    }

    @Override
    public void resolveAllTypes(String string) {
        Class clazz = this.classLoaderService.getValue().classForName(string);
        ResolvedType resolvedType = this.typeResolver.resolve(clazz);
        while (resolvedType != null) {
            this.resolvedTypeCache.put(clazz, resolvedType);
            if ((resolvedType = resolvedType.getParentClass()) == null) continue;
            clazz = resolvedType.getErasedType();
        }
    }

    @Override
    public ResolvedType getResolvedType(Class<?> clazz) {
        return this.resolvedTypeCache.get(clazz);
    }

    @Override
    public ResolvedTypeWithMembers resolveMemberTypes(ResolvedType resolvedType) {
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        return memberResolver.resolve(resolvedType, null, null);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.getMetadataImplementor().getServiceRegistry();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.metadata.getNamingStrategy();
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.metadata.getMappingDefaults();
    }

    @Override
    public MetadataImplementor getMetadataImplementor() {
        return this.metadata;
    }

    @Override
    public <T> Class<T> locateClassByName(String string) {
        return this.classLoaderService.getValue().classForName(string);
    }

    @Override
    public Type makeJavaType(String string) {
        Type type = this.nameToJavaTypeMap.get(string);
        if (type == null) {
            type = this.metadata.makeJavaType(string);
            this.nameToJavaTypeMap.put(string, type);
        }
        return type;
    }

    @Override
    public ValueHolder<Class<?>> makeClassReference(String string) {
        return new ValueHolder(this.locateClassByName(string));
    }

    @Override
    public String qualifyClassName(String string) {
        return string;
    }

    @Override
    public boolean isGloballyQuotedIdentifiers() {
        return this.metadata.isGloballyQuotedIdentifiers();
    }
}

