/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.metamodel.binding.MetaAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAttributeContext {
    private final MetaAttributeContext parentContext;
    private final ConcurrentHashMap<String, MetaAttribute> metaAttributeMap = new ConcurrentHashMap();

    public MetaAttributeContext() {
        this(null);
    }

    public MetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.parentContext = metaAttributeContext;
    }

    public Iterable<String> getKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        this.addKeys(hashSet);
        return hashSet;
    }

    private void addKeys(Set<String> set) {
        set.addAll(this.metaAttributeMap.keySet());
        if (this.parentContext != null) {
            this.parentContext.addKeys(set);
        }
    }

    public Iterable<String> getLocalKeys() {
        return this.metaAttributeMap.keySet();
    }

    public MetaAttribute getMetaAttribute(String string) {
        MetaAttribute metaAttribute = this.getLocalMetaAttribute(string);
        if (metaAttribute == null) {
            metaAttribute = this.parentContext.getMetaAttribute(string);
        }
        return metaAttribute;
    }

    public MetaAttribute getLocalMetaAttribute(String string) {
        return this.metaAttributeMap.get(string);
    }

    public void add(MetaAttribute metaAttribute) {
        this.metaAttributeMap.put(metaAttribute.getName(), metaAttribute);
    }
}

