/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Table;

public class UniqueKey
extends AbstractConstraint
implements Constraint {
    protected UniqueKey(Table table, String string) {
        super(table, string);
    }

    public String getExportIdentifier() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getLoggableValueQualifier());
        stringBuilder.append(".UK");
        for (Column column : this.getColumns()) {
            stringBuilder.append('_').append(column.getColumnName().getName());
        }
        return stringBuilder.toString();
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        String string = dialect.getUniqueDelegate().applyUniquesOnAlter(this);
        return StringHelper.toArrayElement(string);
    }

    public String[] sqlDropStrings(Dialect dialect) {
        String string = dialect.getUniqueDelegate().dropUniquesOnAlter(this);
        return StringHelper.toArrayElement(string);
    }

    protected String sqlConstraintStringInAlterTable(Dialect dialect) {
        return "";
    }
}

