/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.LinkedHashSet;
import org.hibernate.metamodel.relational.Loggable;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Value;
import org.hibernate.metamodel.relational.ValueContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple
implements Value,
ValueContainer,
Loggable {
    private final TableSpecification table;
    private final String name;
    private final LinkedHashSet<SimpleValue> values = new LinkedHashSet();

    public Tuple(TableSpecification tableSpecification, String string) {
        this.table = tableSpecification;
        this.name = string;
    }

    @Override
    public TableSpecification getTable() {
        return this.table;
    }

    public int valuesSpan() {
        return this.values.size();
    }

    @Override
    public Iterable<SimpleValue> values() {
        return this.values;
    }

    public void addValue(SimpleValue simpleValue) {
        if (!simpleValue.getTable().equals(this.getTable())) {
            throw new IllegalArgumentException("Tuple can only group values from same table");
        }
        this.values.add(simpleValue);
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.getTable().getLoggableValueQualifier() + '.' + this.name + "{tuple}";
    }

    @Override
    public String toLoggableString() {
        return this.getLoggableValueQualifier();
    }

    @Override
    public void validateJdbcTypes(Value.JdbcCodes jdbcCodes) {
        for (Value value : this.values()) {
            value.validateJdbcTypes(jdbcCodes);
        }
    }
}

