/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.CheckConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.relational.UniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends AbstractTableSpecification
implements Exportable {
    private final Schema database;
    private final Identifier tableName;
    private final ObjectName objectName;
    private final String qualifiedName;
    private final LinkedHashMap<String, Index> indexes = new LinkedHashMap();
    private final LinkedHashMap<String, UniqueKey> uniqueKeys = new LinkedHashMap();
    private final List<CheckConstraint> checkConstraints = new ArrayList<CheckConstraint>();
    private final List<String> comments = new ArrayList<String>();

    public Table(Schema schema, String string) {
        this(schema, Identifier.toIdentifier(string));
    }

    public Table(Schema schema, Identifier identifier) {
        this.database = schema;
        this.tableName = identifier;
        this.objectName = new ObjectName(schema.getName().getSchema(), schema.getName().getCatalog(), identifier);
        this.qualifiedName = this.objectName.toText();
    }

    @Override
    public Schema getSchema() {
        return this.database;
    }

    public Identifier getTableName() {
        return this.tableName;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.qualifiedName;
    }

    @Override
    public String getExportIdentifier() {
        return this.qualifiedName;
    }

    @Override
    public String toLoggableString() {
        return this.qualifiedName;
    }

    @Override
    public Iterable<Index> getIndexes() {
        return this.indexes.values();
    }

    @Override
    public Index getOrCreateIndex(String string) {
        if (this.indexes.containsKey(string)) {
            return this.indexes.get(string);
        }
        Index index = new Index(this, string);
        this.indexes.put(string, index);
        return index;
    }

    @Override
    public Iterable<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys.values();
    }

    @Override
    public UniqueKey getOrCreateUniqueKey(String string) {
        if (this.uniqueKeys.containsKey(string)) {
            return this.uniqueKeys.get(string);
        }
        UniqueKey uniqueKey = new UniqueKey(this, string);
        this.uniqueKeys.put(string, uniqueKey);
        return uniqueKey;
    }

    @Override
    public Iterable<CheckConstraint> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Override
    public void addCheckConstraint(String string) {
        this.checkConstraints.add(new CheckConstraint(this, "", string));
    }

    @Override
    public Iterable<String> getComments() {
        return this.comments;
    }

    @Override
    public void addComment(String string) {
        this.comments.add(string);
    }

    @Override
    public String getQualifiedName(Dialect dialect) {
        return this.objectName.toText(dialect);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        void var8_13;
        boolean bl = this.getPrimaryKey().getColumns().iterator().hasNext();
        StringBuilder stringBuilder = new StringBuilder(bl ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(this.objectName.toText(dialect)).append(" (");
        boolean bl2 = false;
        String string = null;
        if (bl && bl2) {
            Column column = this.getPrimaryKey().getColumns().iterator().next();
            string = column.getColumnName().encloseInQuotesIfQuoted(dialect);
        }
        boolean bl3 = true;
        for (SimpleValue object : this.values()) {
            Object object2;
            if (!Column.class.isInstance(object)) continue;
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(", ");
            }
            Column column = (Column)object;
            String string2 = column.getColumnName().encloseInQuotesIfQuoted(dialect);
            stringBuilder.append(string2).append(' ');
            if (bl2 && string2.equals(string)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    stringBuilder.append(Table.getTypeString(column, dialect));
                }
                stringBuilder.append(' ').append(dialect.getIdentityColumnString(column.getDatatype().getTypeCode()));
            } else {
                stringBuilder.append(Table.getTypeString(column, dialect));
                object2 = column.getDefaultValue();
                if (object2 != null) {
                    stringBuilder.append(" default ").append((String)object2);
                }
                if (column.isNullable()) {
                    stringBuilder.append(dialect.getNullColumnString());
                } else {
                    stringBuilder.append(" not null");
                }
            }
            if (column.isUnique()) {
                object2 = this.getOrCreateUniqueKey(column.getColumnName().encloseInQuotesIfQuoted(dialect) + '_');
                ((AbstractConstraint)object2).addColumn(column);
                stringBuilder.append(dialect.getUniqueDelegate().applyUniqueToColumn(column));
            }
            if (column.getCheckCondition() != null && dialect.supportsColumnCheck()) {
                stringBuilder.append(" check (").append(column.getCheckCondition()).append(")");
            }
            if ((object2 = column.getComment()) == null) continue;
            stringBuilder.append(dialect.getColumnComment((String)object2));
        }
        if (bl) {
            stringBuilder.append(", ").append(this.getPrimaryKey().sqlConstraintStringInCreateTable(dialect));
        }
        stringBuilder.append(dialect.getUniqueDelegate().applyUniquesToTable(this));
        if (dialect.supportsTableCheck()) {
            for (CheckConstraint checkConstraint : this.checkConstraints) {
                stringBuilder.append(", check (").append(checkConstraint).append(')');
            }
        }
        stringBuilder.append(')');
        stringBuilder.append(dialect.getTableTypeString());
        Iterator<Object> iterator = new String[this.comments.size() + 1];
        iterator[0] = stringBuilder.toString();
        boolean bl4 = false;
        while (var8_13 < this.comments.size()) {
            iterator[var8_13 + true] = dialect.getTableComment(this.comments.get((int)var8_13));
            ++var8_13;
        }
        return iterator;
    }

    private static String getTypeString(Column column, Dialect dialect) {
        String string = null;
        if (column.getSqlType() != null) {
            string = column.getSqlType();
        } else {
            Size size = column.getSize() == null ? new Size() : column.getSize();
            string = dialect.getTypeName(column.getDatatype().getTypeCode(), size.getLength(), size.getPrecision(), size.getScale());
        }
        return string;
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{dialect.getDropTableString(this.getQualifiedName(dialect))};
    }

    public String toString() {
        return "Table{name=" + this.qualifiedName + '}';
    }
}

