/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.io.Serializable;

public class Size
implements Serializable {
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;
    private long length = 255L;
    private int precision = 19;
    private int scale = 2;
    private LobMultiplier lobMultiplier = LobMultiplier.NONE;

    public Size() {
    }

    public Size(int n, int n2, long l, LobMultiplier lobMultiplier) {
        this.precision = n;
        this.scale = n2;
        this.length = l;
        this.lobMultiplier = lobMultiplier;
    }

    public static Size precision(int n) {
        return new Size(n, -1, -1L, null);
    }

    public static Size precision(int n, int n2) {
        return new Size(n, n2, -1L, null);
    }

    public static Size length(long l) {
        return new Size(-1, -1, l, null);
    }

    public static Size length(long l, LobMultiplier lobMultiplier) {
        return new Size(-1, -1, l, lobMultiplier);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public long getLength() {
        return this.length;
    }

    public LobMultiplier getLobMultiplier() {
        return this.lobMultiplier;
    }

    public void initialize(Size size) {
        this.precision = size.precision;
        this.scale = size.scale;
        this.length = size.length;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public void setLobMultiplier(LobMultiplier lobMultiplier) {
        this.lobMultiplier = lobMultiplier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LobMultiplier {
        NONE(1L),
        K(LobMultiplier.NONE.factor * 1024L),
        M(LobMultiplier.K.factor * 1024L),
        G(LobMultiplier.M.factor * 1024L);

        private long factor;

        private LobMultiplier(long l) {
            this.factor = l;
        }

        public long getFactor() {
            return this.factor;
        }
    }
}

