/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.InLineView;
import org.hibernate.metamodel.relational.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private final Name name;
    private Map<String, InLineView> inLineViews = new HashMap<String, InLineView>();
    private Map<Identifier, Table> tables = new HashMap<Identifier, Table>();

    public Schema(Name name) {
        this.name = name;
    }

    public Schema(Identifier identifier, Identifier identifier2) {
        this(new Name(identifier, identifier2));
    }

    public Name getName() {
        return this.name;
    }

    public Table locateTable(Identifier identifier) {
        return this.tables.get(identifier);
    }

    public Table createTable(Identifier identifier) {
        Table table = new Table(this, identifier);
        this.tables.put(identifier, table);
        return table;
    }

    public Table locateOrCreateTable(Identifier identifier) {
        Table table = this.locateTable(identifier);
        if (table == null) {
            return this.createTable(identifier);
        }
        return table;
    }

    public Iterable<Table> getTables() {
        return this.tables.values();
    }

    public InLineView getInLineView(String string) {
        return this.inLineViews.get(string);
    }

    public InLineView createInLineView(String string, String string2) {
        InLineView inLineView = new InLineView(this, string, string2);
        this.inLineViews.put(string, inLineView);
        return inLineView;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Schema");
        stringBuilder.append("{name=").append(this.name);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Schema schema = (Schema)object;
        return !(this.name != null ? !this.name.equals(schema.name) : schema.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static class Name {
        private final Identifier schema;
        private final Identifier catalog;

        public Name(Identifier identifier, Identifier identifier2) {
            this.schema = identifier;
            this.catalog = identifier2;
        }

        public Name(String string, String string2) {
            this(Identifier.toIdentifier(string), Identifier.toIdentifier(string2));
        }

        public Identifier getSchema() {
            return this.schema;
        }

        public Identifier getCatalog() {
            return this.catalog;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Name");
            stringBuilder.append("{schema=").append(this.schema);
            stringBuilder.append(", catalog=").append(this.catalog);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Name name = (Name)object;
            if (this.catalog != null ? !this.catalog.equals(name.catalog) : name.catalog != null) {
                return false;
            }
            return !(this.schema != null ? !this.schema.equals(name.schema) : name.schema != null);
        }

        public int hashCode() {
            int n = this.schema != null ? this.schema.hashCode() : 0;
            n = 31 * n + (this.catalog != null ? this.catalog.hashCode() : 0);
            return n;
        }
    }
}

