/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.TableSpecification;

public class PrimaryKey
extends AbstractConstraint
implements Constraint,
Exportable {
    private String name;

    protected PrimaryKey(TableSpecification tableSpecification) {
        super(tableSpecification, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getExportIdentifier() {
        return this.getTable().getLoggableValueQualifier() + ".PK";
    }

    public String sqlConstraintStringInCreateTable(Dialect dialect) {
        StringBuilder stringBuilder = new StringBuilder("primary key (");
        boolean bl = true;
        for (Column column : this.getColumns()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return stringBuilder.append(')').toString();
    }

    public String sqlConstraintStringInAlterTable(Dialect dialect) {
        StringBuilder stringBuilder = new StringBuilder(dialect.getAddPrimaryKeyConstraintString(this.getName())).append('(');
        boolean bl = true;
        for (Column column : this.getColumns()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return stringBuilder.append(')').toString();
    }
}

