/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.IllegalIdentifierException;
import org.hibernate.metamodel.relational.Schema;

public class ObjectName {
    private static String SEPARATOR = ".";
    private final Identifier schema;
    private final Identifier catalog;
    private final Identifier name;
    private final String identifier;
    private final int hashCode;

    public ObjectName(String string) {
        this(ObjectName.extractSchema(string), ObjectName.extractCatalog(string), ObjectName.extractName(string));
    }

    public ObjectName(Identifier identifier) {
        this(null, null, identifier);
    }

    public ObjectName(Schema schema, String string) {
        this(schema.getName().getSchema(), schema.getName().getCatalog(), Identifier.toIdentifier(string));
    }

    public ObjectName(Schema schema, Identifier identifier) {
        this(schema.getName().getSchema(), schema.getName().getCatalog(), identifier);
    }

    public ObjectName(String string, String string2, String string3) {
        this(Identifier.toIdentifier(string), Identifier.toIdentifier(string2), Identifier.toIdentifier(string3));
    }

    public ObjectName(Identifier identifier, Identifier identifier2, Identifier identifier3) {
        if (identifier3 == null) {
            throw new IllegalIdentifierException("Object name must be specified");
        }
        this.name = identifier3;
        this.schema = identifier;
        this.catalog = identifier2;
        this.identifier = ObjectName.qualify(identifier == null ? null : identifier.toString(), identifier2 == null ? null : identifier2.toString(), identifier3.toString());
        int n = identifier != null ? identifier.hashCode() : 0;
        n = 31 * n + (identifier2 != null ? identifier2.hashCode() : 0);
        this.hashCode = n = 31 * n + identifier3.hashCode();
    }

    public Identifier getSchema() {
        return this.schema;
    }

    public Identifier getCatalog() {
        return this.catalog;
    }

    public Identifier getName() {
        return this.name;
    }

    public String toText() {
        return this.identifier;
    }

    public String toText(Dialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect must be non-null.");
        }
        return ObjectName.qualify(ObjectName.encloseInQuotesIfQuoted(this.schema, dialect), ObjectName.encloseInQuotesIfQuoted(this.catalog, dialect), ObjectName.encloseInQuotesIfQuoted(this.name, dialect));
    }

    private static String encloseInQuotesIfQuoted(Identifier identifier, Dialect dialect) {
        return identifier == null ? null : identifier.encloseInQuotesIfQuoted(dialect);
    }

    private static String qualify(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string3);
        if (string2 != null) {
            stringBuilder.insert(0, string2 + '.');
        }
        if (string != null) {
            stringBuilder.insert(0, string + '.');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        return this.name.equals(objectName.name) && this.areEqual(this.catalog, objectName.catalog) && this.areEqual(this.schema, objectName.schema);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ObjectName{name='" + this.name + '\'' + ", schema='" + this.schema + '\'' + ", catalog='" + this.catalog + '\'' + '}';
    }

    private boolean areEqual(Identifier identifier, Identifier identifier2) {
        return identifier == null ? identifier2 == null : identifier.equals(identifier2);
    }

    private static String extractSchema(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length == 0 || stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return null;
        }
        if (stringArray.length == 3) {
            return stringArray[0];
        }
        throw new HibernateException("Unable to parse object name: " + string);
    }

    private static String extractCatalog(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length == 0 || stringArray.length == 1) {
            return null;
        }
        if (stringArray.length == 2) {
            return null;
        }
        if (stringArray.length == 3) {
            return stringArray[1];
        }
        throw new HibernateException("Unable to parse object name: " + string);
    }

    private static String extractName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length == 0) {
            return string;
        }
        return stringArray[stringArray.length - 1];
    }
}

