/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends AbstractConstraint
implements Constraint {
    protected Index(Table table, String string) {
        super(table, string);
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getLoggableValueQualifier());
        stringBuilder.append(".IDX");
        for (Column column : this.getColumns()) {
            stringBuilder.append('_').append(column.getColumnName().getName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        return new String[]{Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumns(), false)};
    }

    public static String buildSqlCreateIndexString(Dialect dialect, String string, TableSpecification tableSpecification, Iterable<Column> iterable, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("create").append(bl ? " unique" : "").append(" index ").append(dialect.qualifyIndexName() ? string : StringHelper.unqualify(string)).append(" on ").append(tableSpecification.getQualifiedName(dialect)).append(" (");
        boolean bl2 = true;
        for (Column column : iterable) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String buildSqlDropIndexString(Dialect dialect, TableSpecification tableSpecification, String string) {
        return "drop index " + StringHelper.qualify(tableSpecification.getQualifiedName(dialect), string);
    }

    @Override
    public String sqlConstraintStringInAlterTable(Dialect dialect) {
        StringBuilder stringBuilder = new StringBuilder(" index (");
        boolean bl = true;
        for (Column column : this.getColumns()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{"drop index " + StringHelper.qualify(this.getTable().getQualifiedName(dialect), this.getName())};
    }
}

