/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.IllegalIdentifierException;

public class Identifier {
    private final String name;
    private final boolean isQuoted;

    public static Identifier toIdentifier(String string) {
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        String string2 = string.trim();
        if (Identifier.isQuoted(string2)) {
            String string3 = string2.substring(1, string2.length() - 1);
            return new Identifier(string3, true);
        }
        return new Identifier(string2, false);
    }

    public static boolean isQuoted(String string) {
        return string.startsWith("`") && string.endsWith("`");
    }

    public Identifier(String string, boolean bl) {
        if (StringHelper.isEmpty(string)) {
            throw new IllegalIdentifierException("Identifier text cannot be null");
        }
        if (Identifier.isQuoted(string)) {
            throw new IllegalIdentifierException("Identifier text should not contain quote markers (`)");
        }
        this.name = string;
        this.isQuoted = bl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public String encloseInQuotesIfQuoted(Dialect dialect) {
        return this.isQuoted ? new StringBuilder(this.name.length() + 2).append(dialect.openQuote()).append(this.name).append(dialect.closeQuote()).toString() : this.name;
    }

    public String toString() {
        return this.isQuoted ? '`' + this.getName() + '`' : this.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        return this.isQuoted == identifier.isQuoted && this.name.equals(identifier.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

