/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.TableSpecification;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey
extends AbstractConstraint
implements Constraint,
Exportable {
    private static final Logger LOG = Logger.getLogger(ForeignKey.class);
    private static final String ON_DELETE = " on delete ";
    private static final String ON_UPDATE = " on update ";
    private final TableSpecification targetTable;
    private List<Column> targetColumns;
    private ReferentialAction deleteRule = ReferentialAction.NO_ACTION;
    private ReferentialAction updateRule = ReferentialAction.NO_ACTION;

    protected ForeignKey(TableSpecification tableSpecification, TableSpecification tableSpecification2, String string) {
        super(tableSpecification, string);
        this.targetTable = tableSpecification2;
    }

    protected ForeignKey(TableSpecification tableSpecification, TableSpecification tableSpecification2) {
        this(tableSpecification, tableSpecification2, null);
    }

    public TableSpecification getSourceTable() {
        return this.getTable();
    }

    public TableSpecification getTargetTable() {
        return this.targetTable;
    }

    public Iterable<Column> getSourceColumns() {
        return this.getColumns();
    }

    public Iterable<Column> getTargetColumns() {
        return this.targetColumns == null ? this.getTargetTable().getPrimaryKey().getColumns() : this.targetColumns;
    }

    @Override
    public void addColumn(Column column) {
        this.addColumnMapping(column, null);
    }

    public void addColumnMapping(Column column, Column column2) {
        if (column2 == null) {
            if (this.targetColumns != null) {
                LOG.debugf("Attempt to map column [%s] to no target column after explicit target column(s) named for FK [name=%s]", (Object)column.toLoggableString(), (Object)this.getName());
            }
        } else {
            this.checkTargetTable(column2);
            if (this.targetColumns == null) {
                if (!this.internalColumnAccess().isEmpty()) {
                    LOG.debugf("Value mapping mismatch as part of FK [table=%s, name=%s] while adding source column [%s]", (Object)this.getTable().toLoggableString(), (Object)this.getName(), (Object)column.toLoggableString());
                }
                this.targetColumns = new ArrayList<Column>();
            }
            this.targetColumns.add(column2);
        }
        this.internalAddColumn(column);
    }

    private void checkTargetTable(Column column) {
        if (column.getTable() != this.getTargetTable()) {
            throw new AssertionFailure(String.format("Unable to add column to constraint; tables [%s, %s] did not match", column.getTable().toLoggableString(), this.getTargetTable().toLoggableString()));
        }
    }

    @Override
    public String getExportIdentifier() {
        return this.getSourceTable().getLoggableValueQualifier() + ".FK-" + this.getName();
    }

    public ReferentialAction getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(ReferentialAction referentialAction) {
        this.deleteRule = referentialAction;
    }

    public ReferentialAction getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(ReferentialAction referentialAction) {
        this.updateRule = referentialAction;
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{"alter table " + this.getTable().getQualifiedName(dialect) + dialect.getDropForeignKeyString() + this.getName()};
    }

    @Override
    public String sqlConstraintStringInAlterTable(Dialect dialect) {
        String[] stringArray = new String[this.getColumnSpan()];
        String[] stringArray2 = new String[this.getColumnSpan()];
        int n = 0;
        Iterator<Column> iterator = this.getTargetColumns().iterator();
        for (Column column : this.getColumns()) {
            if (!iterator.hasNext()) {
                throw new MappingException("More constraint columns that foreign key target columns.");
            }
            stringArray[n] = column.getColumnName().encloseInQuotesIfQuoted(dialect);
            stringArray2[n] = iterator.next().getColumnName().encloseInQuotesIfQuoted(dialect);
            ++n;
        }
        if (iterator.hasNext()) {
            throw new MappingException("More foreign key target columns than constraint columns.");
        }
        StringBuilder stringBuilder = new StringBuilder(dialect.getAddForeignKeyConstraintString(this.getName(), stringArray, this.targetTable.getQualifiedName(dialect), stringArray2, this.targetColumns == null));
        if (dialect.supportsCascadeDelete()) {
            if (this.deleteRule != ReferentialAction.NO_ACTION) {
                stringBuilder.append(ON_DELETE).append(this.deleteRule.getActionString());
            }
            if (this.updateRule != ReferentialAction.NO_ACTION) {
                stringBuilder.append(ON_UPDATE).append(this.updateRule.getActionString());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferentialAction {
        NO_ACTION("no action"),
        CASCADE("cascade"),
        SET_NULL("set null"),
        SET_DEFAULT("set default"),
        RESTRICT("restrict");

        private final String actionString;

        private ReferentialAction(String string2) {
            this.actionString = string2;
        }

        public String getActionString() {
            return this.actionString;
        }
    }
}

