/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

public class Datatype {
    private final int typeCode;
    private final String typeName;
    private final Class javaType;
    private final int hashCode;

    public Datatype(int n, String string, Class clazz) {
        this.typeCode = n;
        this.typeName = string;
        this.javaType = clazz;
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int n = this.typeCode;
        if (this.typeName != null) {
            n = 31 * n + this.typeName.hashCode();
        }
        if (this.javaType != null) {
            n = 31 * n + this.javaType.hashCode();
        }
        return n;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Datatype datatype = (Datatype)object;
        return this.typeCode == datatype.typeCode && this.javaType.equals(datatype.javaType) && this.typeName.equals(datatype.typeName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return super.toString() + "[code=" + this.typeCode + ", name=" + this.typeName + ", javaClass=" + this.javaType.getName() + "]";
    }
}

