/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.UniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private final Schema.Name implicitSchemaName;
    private final Map<Schema.Name, Schema> schemaMap = new HashMap<Schema.Name, Schema>();
    private final List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();

    public Database(Metadata.Options options) {
        String string = options.getDefaultSchemaName();
        String string2 = options.getDefaultCatalogName();
        if (options.isGloballyQuotedIdentifiers()) {
            string = StringHelper.quote(string);
            string2 = StringHelper.quote(string2);
        }
        this.implicitSchemaName = new Schema.Name(string, string2);
        this.makeSchema(this.implicitSchemaName);
    }

    public Schema getDefaultSchema() {
        return this.schemaMap.get(this.implicitSchemaName);
    }

    public Schema locateSchema(Schema.Name name) {
        if (name.getSchema() == null && name.getCatalog() == null) {
            return this.getDefaultSchema();
        }
        Schema schema = this.schemaMap.get(name);
        if (schema == null) {
            schema = this.makeSchema(name);
        }
        return schema;
    }

    private Schema makeSchema(Schema.Name name) {
        Schema schema = new Schema(name);
        this.schemaMap.put(name, schema);
        return schema;
    }

    public Schema getSchema(Identifier identifier, Identifier identifier2) {
        return this.locateSchema(new Schema.Name(identifier, identifier2));
    }

    public Schema getSchema(String string, String string2) {
        return this.locateSchema(new Schema.Name(Identifier.toIdentifier(string), Identifier.toIdentifier(string2)));
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (auxiliaryDatabaseObject == null) {
            throw new IllegalArgumentException("Auxiliary database object is null.");
        }
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Iterable<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects() {
        return this.auxiliaryDatabaseObjects;
    }

    public String[] generateSchemaCreationScript(Dialect dialect) {
        HashSet<String> hashSet = new HashSet<String>(50);
        ArrayList<String> arrayList = new ArrayList<String>(50);
        for (Schema object : this.schemaMap.values()) {
            for (Table table : object.getTables()) {
                Database.addSqlCreateStrings(dialect, hashSet, arrayList, table);
            }
        }
        for (Schema schema : this.schemaMap.values()) {
            for (Table table : schema.getTables()) {
                for (UniqueKey uniqueKey : table.getUniqueKeys()) {
                    Database.addSqlCreateStrings(dialect, hashSet, arrayList, uniqueKey);
                }
                for (Index index : table.getIndexes()) {
                    Database.addSqlCreateStrings(dialect, hashSet, arrayList, index);
                }
                if (!dialect.hasAlterTable()) continue;
                for (ForeignKey foreignKey : table.getForeignKeys()) {
                    if (!Table.class.isInstance(foreignKey.getTargetTable())) continue;
                    Database.addSqlCreateStrings(dialect, hashSet, arrayList, foreignKey);
                }
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            Database.addSqlCreateStrings(dialect, hashSet, arrayList, auxiliaryDatabaseObject);
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateDropSchemaScript(Dialect dialect) {
        HashSet<String> hashSet = new HashSet<String>(50);
        ArrayList<String> arrayList = new ArrayList<String>(50);
        for (int i = this.auxiliaryDatabaseObjects.size() - 1; i >= 0; --i) {
            AuxiliaryDatabaseObject object = this.auxiliaryDatabaseObjects.get(i);
            if (!object.appliesToDialect(dialect)) continue;
            Database.addSqlDropStrings(dialect, hashSet, arrayList, object);
        }
        if (dialect.dropConstraints()) {
            for (Schema schema : this.schemaMap.values()) {
                for (Table table : schema.getTables()) {
                    for (ForeignKey foreignKey : table.getForeignKeys()) {
                        if (!(foreignKey.getTargetTable() instanceof Table)) continue;
                        Database.addSqlDropStrings(dialect, hashSet, arrayList, foreignKey);
                    }
                }
            }
        }
        for (Schema schema : this.schemaMap.values()) {
            for (Table table : schema.getTables()) {
                Database.addSqlDropStrings(dialect, hashSet, arrayList, table);
            }
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    private static void addSqlDropStrings(Dialect dialect, Set<String> set, List<String> list, Exportable exportable) {
        Database.addSqlStrings(set, list, exportable.getExportIdentifier(), exportable.sqlDropStrings(dialect));
    }

    private static void addSqlCreateStrings(Dialect dialect, Set<String> set, List<String> list, Exportable exportable) {
        Database.addSqlStrings(set, list, exportable.getExportIdentifier(), exportable.sqlCreateStrings(dialect));
    }

    private static void addSqlStrings(Set<String> set, List<String> list, String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (set.contains(string)) {
            throw new MappingException("SQL strings added more than once for: " + string);
        }
        set.add(string);
        list.addAll(Arrays.asList(stringArray));
    }
}

