/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractSimpleValue;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.state.ColumnRelationalState;

public class Column
extends AbstractSimpleValue {
    private final Identifier columnName;
    private boolean nullable;
    private boolean unique;
    private String defaultValue;
    private String checkCondition;
    private String sqlType;
    private String readFragment;
    private String writeFragment;
    private String comment;
    private Size size = new Size();

    protected Column(TableSpecification tableSpecification, int n, String string) {
        this(tableSpecification, n, Identifier.toIdentifier(string));
    }

    protected Column(TableSpecification tableSpecification, int n, Identifier identifier) {
        super(tableSpecification, n);
        this.columnName = identifier;
    }

    public void initialize(ColumnRelationalState columnRelationalState, boolean bl, boolean bl2) {
        this.size.initialize(columnRelationalState.getSize());
        this.nullable = !bl && columnRelationalState.isNullable();
        this.unique = !bl2 && columnRelationalState.isUnique();
        this.checkCondition = columnRelationalState.getCheckCondition();
        this.defaultValue = columnRelationalState.getDefault();
        this.sqlType = columnRelationalState.getSqlType();
        this.writeFragment = columnRelationalState.getCustomWriteFragment();
        this.readFragment = columnRelationalState.getCustomReadFragment();
        this.comment = columnRelationalState.getComment();
        for (String string : columnRelationalState.getUniqueKeys()) {
            this.getTable().getOrCreateUniqueKey(string).addColumn(this);
        }
        for (String string : columnRelationalState.getIndexes()) {
            this.getTable().getOrCreateIndex(string).addColumn(this);
        }
    }

    public Identifier getColumnName() {
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getCheckCondition() {
        return this.checkCondition;
    }

    public void setCheckCondition(String string) {
        this.checkCondition = string;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String string) {
        this.sqlType = string;
    }

    public String getReadFragment() {
        return this.readFragment;
    }

    public void setReadFragment(String string) {
        this.readFragment = string;
    }

    public String getWriteFragment() {
        return this.writeFragment;
    }

    public void setWriteFragment(String string) {
        this.writeFragment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public String toLoggableString() {
        return this.getTable().getLoggableValueQualifier() + '.' + this.getColumnName();
    }

    public String getAlias(Dialect dialect) {
        boolean bl;
        String string = this.columnName.getName();
        int n = StringHelper.lastIndexOfLetter(this.columnName.getName());
        if (n == -1) {
            string = "column";
        }
        boolean bl2 = bl = this.columnName.getName().equals(string) && string.length() <= dialect.getMaxAliasLength() && !this.columnName.isQuoted() && !this.columnName.getName().toLowerCase().equals("rowid");
        if (!bl) {
            String string2 = "" + this.getPosition() + '_' + this.getTable().getTableNumber() + '_';
            if (string2.length() >= dialect.getMaxAliasLength()) {
                throw new MappingException("Unique suffix [" + string2 + "] length must be less than maximum [" + dialect.getMaxAliasLength() + "]");
            }
            if (string.length() + string2.length() > dialect.getMaxAliasLength()) {
                string = string.substring(0, dialect.getMaxAliasLength() - string2.length());
            }
            string = string + string2;
        }
        return string;
    }
}

