/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.PrimaryKey;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableSpecification
implements TableSpecification {
    private static final AtomicInteger tableCounter = new AtomicInteger(0);
    private final int tableNumber;
    private final LinkedHashMap<String, SimpleValue> values = new LinkedHashMap();
    private final PrimaryKey primaryKey = new PrimaryKey(this);
    private final List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();

    public AbstractTableSpecification() {
        this.tableNumber = tableCounter.getAndIncrement();
    }

    @Override
    public int getTableNumber() {
        return this.tableNumber;
    }

    @Override
    public Iterable<SimpleValue> values() {
        return this.values.values();
    }

    @Override
    public Column locateOrCreateColumn(String string) {
        if (this.values.containsKey(string)) {
            return (Column)this.values.get(string);
        }
        Column column = new Column((TableSpecification)this, this.values.size(), string);
        this.values.put(string, column);
        return column;
    }

    @Override
    public DerivedValue locateOrCreateDerivedValue(String string) {
        if (this.values.containsKey(string)) {
            return (DerivedValue)this.values.get(string);
        }
        DerivedValue derivedValue = new DerivedValue(this, this.values.size(), string);
        this.values.put(string, derivedValue);
        return derivedValue;
    }

    @Override
    public Tuple createTuple(String string) {
        return new Tuple(this, string);
    }

    @Override
    public Iterable<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public ForeignKey createForeignKey(TableSpecification tableSpecification, String string) {
        ForeignKey foreignKey = new ForeignKey(this, tableSpecification, string);
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }
}

