/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.ValidationException;
import org.hibernate.metamodel.relational.Datatype;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Value;
import org.jboss.logging.Logger;

public abstract class AbstractSimpleValue
implements SimpleValue {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractSimpleValue.class.getName());
    private final TableSpecification table;
    private final int position;
    private Datatype datatype;

    protected AbstractSimpleValue(TableSpecification tableSpecification, int n) {
        this.table = tableSpecification;
        this.position = n;
    }

    public TableSpecification getTable() {
        return this.table;
    }

    public int getPosition() {
        return this.position;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        LOG.debugf("setting datatype for column %s : %s", (Object)this.toLoggableString(), (Object)datatype);
        if (this.datatype != null && !this.datatype.equals(datatype)) {
            LOG.debugf("overriding previous datatype : %s", (Object)this.datatype);
        }
        this.datatype = datatype;
    }

    public void validateJdbcTypes(Value.JdbcCodes jdbcCodes) {
        if (this.datatype.getTypeCode() != jdbcCodes.nextJdbcCde()) {
            throw new ValidationException("Mismatched types");
        }
    }
}

