/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.domain;

import org.hibernate.internal.util.ValueHolder;
import org.hibernate.service.classloading.spi.ClassLoaderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaType {
    private final String name;
    private final ValueHolder<Class<?>> classReference;

    public JavaType(final String string, final ClassLoaderService classLoaderService) {
        this.name = string;
        this.classReference = new ValueHolder<1>(new ValueHolder.DeferredInitializer<Class<?>>(){

            @Override
            public Class<?> initialize() {
                return classLoaderService.classForName(string);
            }
        });
    }

    public JavaType(Class<?> clazz) {
        this.name = clazz.getName();
        this.classReference = new ValueHolder(clazz);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClassReference() {
        return this.classReference.getValue();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

