/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Component;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.domain.IndexedPluralAttribute;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.domain.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeContainer
implements AttributeContainer,
Hierarchical {
    private final String name;
    private final String className;
    private final ValueHolder<Class<?>> classReference;
    private final Hierarchical superType;
    private LinkedHashSet<Attribute> attributeSet = new LinkedHashSet();
    private HashMap<String, Attribute> attributeMap = new HashMap();

    public AbstractAttributeContainer(String string, String string2, ValueHolder<Class<?>> valueHolder, Hierarchical hierarchical) {
        this.name = string;
        this.className = string2;
        this.classReference = valueHolder;
        this.superType = hierarchical;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> getClassReference() {
        return this.classReference.getValue();
    }

    @Override
    public ValueHolder<Class<?>> getClassReferenceUnresolved() {
        return this.classReference;
    }

    @Override
    public Hierarchical getSuperType() {
        return this.superType;
    }

    @Override
    public Set<Attribute> attributes() {
        return Collections.unmodifiableSet(this.attributeSet);
    }

    @Override
    public String getRoleBaseName() {
        return this.getClassName();
    }

    @Override
    public Attribute locateAttribute(String string) {
        return this.attributeMap.get(string);
    }

    @Override
    public SingularAttribute locateSingularAttribute(String string) {
        return (SingularAttribute)this.locateAttribute(string);
    }

    @Override
    public SingularAttribute createSingularAttribute(String string) {
        SingularAttributeImpl singularAttributeImpl = new SingularAttributeImpl(string, this);
        this.addAttribute(singularAttributeImpl);
        return singularAttributeImpl;
    }

    @Override
    public SingularAttribute createVirtualSingularAttribute(String string) {
        throw new NotYetImplementedException();
    }

    @Override
    public SingularAttribute locateComponentAttribute(String string) {
        return (SingularAttributeImpl)this.locateAttribute(string);
    }

    @Override
    public SingularAttribute createComponentAttribute(String string, Component component) {
        SingularAttributeImpl singularAttributeImpl = new SingularAttributeImpl(string, this);
        singularAttributeImpl.resolveType(component);
        this.addAttribute(singularAttributeImpl);
        return singularAttributeImpl;
    }

    @Override
    public PluralAttribute locatePluralAttribute(String string) {
        return (PluralAttribute)this.locateAttribute(string);
    }

    protected PluralAttribute createPluralAttribute(String string, PluralAttributeNature pluralAttributeNature) {
        PluralAttributeImpl pluralAttributeImpl = pluralAttributeNature.isIndexed() ? new IndexedPluralAttributeImpl(string, pluralAttributeNature, this) : new PluralAttributeImpl(string, pluralAttributeNature, this);
        this.addAttribute(pluralAttributeImpl);
        return pluralAttributeImpl;
    }

    @Override
    public PluralAttribute locateBag(String string) {
        return this.locatePluralAttribute(string);
    }

    @Override
    public PluralAttribute createBag(String string) {
        return this.createPluralAttribute(string, PluralAttributeNature.BAG);
    }

    @Override
    public PluralAttribute locateSet(String string) {
        return this.locatePluralAttribute(string);
    }

    @Override
    public PluralAttribute createSet(String string) {
        return this.createPluralAttribute(string, PluralAttributeNature.SET);
    }

    @Override
    public IndexedPluralAttribute locateList(String string) {
        return (IndexedPluralAttribute)this.locatePluralAttribute(string);
    }

    @Override
    public IndexedPluralAttribute createList(String string) {
        return (IndexedPluralAttribute)this.createPluralAttribute(string, PluralAttributeNature.LIST);
    }

    @Override
    public IndexedPluralAttribute locateMap(String string) {
        return (IndexedPluralAttribute)this.locatePluralAttribute(string);
    }

    @Override
    public IndexedPluralAttribute createMap(String string) {
        return (IndexedPluralAttribute)this.createPluralAttribute(string, PluralAttributeNature.MAP);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AbstractAttributeContainer");
        stringBuilder.append("{name='").append(this.name).append('\'');
        stringBuilder.append(", superType=").append(this.superType);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected void addAttribute(Attribute attribute) {
        if (this.attributeMap.put(attribute.getName(), attribute) != null) {
            throw new IllegalArgumentException("Attribute with name [" + attribute.getName() + "] already registered");
        }
        this.attributeSet.add(attribute);
    }

    public static class IndexedPluralAttributeImpl
    extends PluralAttributeImpl
    implements IndexedPluralAttribute {
        private Type indexType;

        public IndexedPluralAttributeImpl(String string, PluralAttributeNature pluralAttributeNature, AttributeContainer attributeContainer) {
            super(string, pluralAttributeNature, attributeContainer);
        }

        public Type getIndexType() {
            return this.indexType;
        }

        public void setIndexType(Type type) {
            this.indexType = type;
        }
    }

    public static class PluralAttributeImpl
    implements PluralAttribute {
        private final AttributeContainer attributeContainer;
        private final PluralAttributeNature nature;
        private final String name;
        private Type elementType;

        public PluralAttributeImpl(String string, PluralAttributeNature pluralAttributeNature, AttributeContainer attributeContainer) {
            this.name = string;
            this.nature = pluralAttributeNature;
            this.attributeContainer = attributeContainer;
        }

        public AttributeContainer getAttributeContainer() {
            return this.attributeContainer;
        }

        public boolean isSingular() {
            return false;
        }

        public PluralAttributeNature getNature() {
            return this.nature;
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return StringHelper.qualify(this.attributeContainer.getRoleBaseName(), this.name);
        }

        public Type getElementType() {
            return this.elementType;
        }

        public void setElementType(Type type) {
            this.elementType = type;
        }
    }

    public static class SingularAttributeImpl
    implements SingularAttribute {
        private final AttributeContainer attributeContainer;
        private final String name;
        private Type type;

        public SingularAttributeImpl(String string, AttributeContainer attributeContainer) {
            this.name = string;
            this.attributeContainer = attributeContainer;
        }

        public boolean isTypeResolved() {
            return this.type != null;
        }

        public void resolveType(Type type) {
            if (type == null) {
                throw new IllegalArgumentException("Attempt to resolve with null type");
            }
            this.type = type;
        }

        public Type getSingularAttributeType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public AttributeContainer getAttributeContainer() {
            return this.attributeContainer;
        }

        public boolean isSingular() {
            return true;
        }
    }
}

