/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.SimpleValue;

public class SimpleValueBinding {
    private SimpleValue simpleValue;
    private boolean includeInInsert;
    private boolean includeInUpdate;

    public SimpleValueBinding() {
        this(true, true);
    }

    public SimpleValueBinding(SimpleValue simpleValue) {
        this();
        this.setSimpleValue(simpleValue);
    }

    public SimpleValueBinding(SimpleValue simpleValue, boolean bl, boolean bl2) {
        this(bl, bl2);
        this.setSimpleValue(simpleValue);
    }

    public SimpleValueBinding(boolean bl, boolean bl2) {
        this.includeInInsert = bl;
        this.includeInUpdate = bl2;
    }

    public SimpleValue getSimpleValue() {
        return this.simpleValue;
    }

    public void setSimpleValue(SimpleValue simpleValue) {
        this.simpleValue = simpleValue;
        if (DerivedValue.class.isInstance(simpleValue)) {
            this.includeInInsert = false;
            this.includeInUpdate = false;
        }
    }

    public boolean isDerived() {
        return DerivedValue.class.isInstance(this.simpleValue);
    }

    public boolean isNullable() {
        return this.isDerived() || ((Column)Column.class.cast(this.simpleValue)).isNullable();
    }

    public boolean isIncludeInInsert() {
        return this.includeInInsert;
    }

    public void setIncludeInInsert(boolean bl) {
        this.includeInInsert = bl;
    }

    public boolean isIncludeInUpdate() {
        return this.includeInUpdate;
    }

    public void setIncludeInUpdate(boolean bl) {
        this.includeInUpdate = bl;
    }
}

