/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.domain.SingularAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToOneAttributeBinding
extends BasicAttributeBinding
implements SingularAssociationAttributeBinding {
    private String referencedEntityName;
    private String referencedAttributeName;
    private AttributeBinding referencedAttributeBinding;
    private boolean isLogicalOneToOne;
    private String foreignKeyName;
    private CascadeStyle cascadeStyle;
    private FetchTiming fetchTiming;
    private FetchStyle fetchStyle;

    ManyToOneAttributeBinding(AttributeBindingContainer attributeBindingContainer, SingularAttribute singularAttribute) {
        super(attributeBindingContainer, singularAttribute, false, false);
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public final boolean isPropertyReference() {
        return this.referencedAttributeName != null;
    }

    @Override
    public final String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string;
    }

    @Override
    public final String getReferencedAttributeName() {
        return this.referencedAttributeName;
    }

    @Override
    public void setReferencedAttributeName(String string) {
        this.referencedAttributeName = string;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void setCascadeStyles(Iterable<CascadeStyle> iterable) {
        ArrayList<CascadeStyle> arrayList = new ArrayList<CascadeStyle>();
        for (CascadeStyle cascadeStyle : iterable) {
            if (cascadeStyle == CascadeStyle.NONE) continue;
            arrayList.add(cascadeStyle);
        }
        this.cascadeStyle = arrayList.isEmpty() ? CascadeStyle.NONE : (arrayList.size() == 1 ? (CascadeStyle)arrayList.get(0) : new CascadeStyle.MultipleCascadeStyle(arrayList.toArray(new CascadeStyle[arrayList.size()])));
    }

    @Override
    public FetchTiming getFetchTiming() {
        return this.fetchTiming;
    }

    @Override
    public void setFetchTiming(FetchTiming fetchTiming) {
        this.fetchTiming = fetchTiming;
    }

    @Override
    public FetchStyle getFetchStyle() {
        return this.fetchStyle;
    }

    @Override
    public void setFetchStyle(FetchStyle fetchStyle) {
        if (fetchStyle == FetchStyle.SUBSELECT) {
            throw new AssertionFailure("Subselect fetching not yet supported for singular associations");
        }
        this.fetchStyle = fetchStyle;
    }

    @Override
    public FetchMode getFetchMode() {
        if (this.fetchStyle == FetchStyle.JOIN) {
            return FetchMode.JOIN;
        }
        if (this.fetchStyle == FetchStyle.SELECT) {
            return FetchMode.SELECT;
        }
        if (this.fetchStyle == FetchStyle.BATCH) {
            return FetchMode.SELECT;
        }
        throw new AssertionFailure("Unexpected fetch style : " + this.fetchStyle.name());
    }

    @Override
    public final boolean isReferenceResolved() {
        return this.referencedAttributeBinding != null;
    }

    @Override
    public final void resolveReference(AttributeBinding attributeBinding) {
        if (!EntityBinding.class.isInstance(attributeBinding.getContainer())) {
            throw new AssertionFailure("Illegal attempt to resolve many-to-one reference based on non-entity attribute");
        }
        EntityBinding entityBinding = (EntityBinding)attributeBinding.getContainer();
        if (!this.referencedEntityName.equals(entityBinding.getEntity().getName())) {
            throw new IllegalStateException("attempt to set EntityBinding with name: [" + entityBinding.getEntity().getName() + "; entity name should be: " + this.referencedEntityName);
        }
        if (this.referencedAttributeName == null) {
            this.referencedAttributeName = attributeBinding.getAttribute().getName();
        } else if (!this.referencedAttributeName.equals(attributeBinding.getAttribute().getName())) {
            throw new IllegalStateException("Inconsistent attribute name; expected: " + this.referencedAttributeName + "actual: " + attributeBinding.getAttribute().getName());
        }
        this.referencedAttributeBinding = attributeBinding;
    }

    @Override
    public AttributeBinding getReferencedAttributeBinding() {
        if (!this.isReferenceResolved()) {
            throw new IllegalStateException("Referenced AttributeBiding has not been resolved.");
        }
        return this.referencedAttributeBinding;
    }

    @Override
    public final EntityBinding getReferencedEntityBinding() {
        return (EntityBinding)this.referencedAttributeBinding.getContainer();
    }
}

