/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.collections.JoinedIterable;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.ComponentAttributeBinding;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.Helper;
import org.hibernate.metamodel.binding.HierarchyDetails;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SetBinding;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.source.MetaAttributeContext;
import org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBinding
implements AttributeBindingContainer {
    private static final String NULL_DISCRIMINATOR_MATCH_VALUE = "null";
    private static final String NOT_NULL_DISCRIMINATOR_MATCH_VALUE = "not null";
    private final EntityBinding superEntityBinding;
    private final List<EntityBinding> subEntityBindings = new ArrayList<EntityBinding>();
    private final HierarchyDetails hierarchyDetails;
    private Entity entity;
    private TableSpecification primaryTable;
    private String primaryTableName;
    private Map<String, TableSpecification> secondaryTables = new HashMap<String, TableSpecification>();
    private ValueHolder<Class<?>> proxyInterfaceType;
    private String jpaEntityName;
    private Class<? extends EntityPersister> customEntityPersisterClass;
    private Class<? extends EntityTuplizer> customEntityTuplizerClass;
    private String discriminatorMatchValue;
    private Set<FilterDefinition> filterDefinitions = new HashSet<FilterDefinition>();
    private Set<SingularAssociationAttributeBinding> entityReferencingAttributeBindings = new HashSet<SingularAssociationAttributeBinding>();
    private MetaAttributeContext metaAttributeContext;
    private boolean lazy;
    private boolean mutable;
    private String whereFilter;
    private String rowId;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private boolean hasSubselectLoadableCollections;
    private Boolean isAbstract;
    private String customLoaderName;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private Set<String> synchronizedTableNames = new HashSet<String>();
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private List<JpaCallbackClass> jpaCallbackClasses = new ArrayList<JpaCallbackClass>();

    public EntityBinding(InheritanceType inheritanceType, EntityMode entityMode) {
        this.superEntityBinding = null;
        this.hierarchyDetails = new HierarchyDetails(this, inheritanceType, entityMode);
    }

    public EntityBinding(EntityBinding entityBinding) {
        this.superEntityBinding = entityBinding;
        this.superEntityBinding.subEntityBindings.add(this);
        this.hierarchyDetails = entityBinding.getHierarchyDetails();
    }

    public HierarchyDetails getHierarchyDetails() {
        return this.hierarchyDetails;
    }

    public EntityBinding getSuperEntityBinding() {
        return this.superEntityBinding;
    }

    public boolean isRoot() {
        return this.superEntityBinding == null;
    }

    public boolean isPolymorphic() {
        return this.superEntityBinding != null || this.hierarchyDetails.getEntityDiscriminator() != null || !this.subEntityBindings.isEmpty();
    }

    public boolean hasSubEntityBindings() {
        return this.subEntityBindings.size() > 0;
    }

    public int getSubEntityBindingClosureSpan() {
        int n = this.subEntityBindings.size();
        for (EntityBinding entityBinding : this.subEntityBindings) {
            n += entityBinding.getSubEntityBindingClosureSpan();
        }
        return n;
    }

    public Iterable<EntityBinding> getDirectSubEntityBindings() {
        return this.subEntityBindings;
    }

    public Iterable<EntityBinding> getPostOrderSubEntityBindingClosure() {
        ArrayList arrayList = new ArrayList(this.subEntityBindings.size() + 1);
        for (EntityBinding entityBinding : this.subEntityBindings) {
            Iterable<EntityBinding> iterable = entityBinding.getPostOrderSubEntityBindingClosure();
            if (!iterable.iterator().hasNext()) continue;
            arrayList.add(iterable);
        }
        if (!this.subEntityBindings.isEmpty()) {
            arrayList.add(this.subEntityBindings);
        }
        return new JoinedIterable<EntityBinding>(arrayList);
    }

    public Iterable<EntityBinding> getPreOrderSubEntityBindingClosure() {
        return this.getPreOrderSubEntityBindingClosure(false);
    }

    private Iterable<EntityBinding> getPreOrderSubEntityBindingClosure(boolean bl) {
        ArrayList arrayList = new ArrayList();
        if (bl) {
            arrayList.add(Collections.singletonList(this));
        }
        for (EntityBinding entityBinding : this.subEntityBindings) {
            Iterable<EntityBinding> iterable = entityBinding.getPreOrderSubEntityBindingClosure(true);
            if (!iterable.iterator().hasNext()) continue;
            arrayList.add(iterable);
        }
        return new JoinedIterable<EntityBinding>(arrayList);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public TableSpecification getPrimaryTable() {
        return this.primaryTable;
    }

    public void setPrimaryTable(TableSpecification tableSpecification) {
        this.primaryTable = tableSpecification;
    }

    public TableSpecification locateTable(String string) {
        if (string == null || string.equals(this.getPrimaryTableName())) {
            return this.primaryTable;
        }
        TableSpecification tableSpecification = this.secondaryTables.get(string);
        if (tableSpecification == null) {
            throw new AssertionFailure(String.format("Unable to find table %s amongst tables %s", string, this.secondaryTables.keySet()));
        }
        return tableSpecification;
    }

    public String getPrimaryTableName() {
        return this.primaryTableName;
    }

    public void setPrimaryTableName(String string) {
        this.primaryTableName = string;
    }

    public void addSecondaryTable(String string, TableSpecification tableSpecification) {
        this.secondaryTables.put(string, tableSpecification);
    }

    public boolean isVersioned() {
        return this.getHierarchyDetails().getVersioningAttributeBinding() != null;
    }

    public boolean isDiscriminatorMatchValueNull() {
        return NULL_DISCRIMINATOR_MATCH_VALUE.equals(this.discriminatorMatchValue);
    }

    public boolean isDiscriminatorMatchValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MATCH_VALUE.equals(this.discriminatorMatchValue);
    }

    public String getDiscriminatorMatchValue() {
        return this.discriminatorMatchValue;
    }

    public void setDiscriminatorMatchValue(String string) {
        this.discriminatorMatchValue = string;
    }

    public Iterable<FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.add(filterDefinition);
    }

    public Iterable<SingularAssociationAttributeBinding> getEntityReferencingAttributeBindings() {
        return this.entityReferencingAttributeBindings;
    }

    @Override
    public EntityBinding seekEntityBinding() {
        return this;
    }

    @Override
    public String getPathBase() {
        return this.getEntity().getName();
    }

    @Override
    public Class<?> getClassReference() {
        return this.getEntity().getClassReference();
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.getEntity();
    }

    protected void registerAttributeBinding(String string, AttributeBinding attributeBinding) {
        if (SingularAssociationAttributeBinding.class.isInstance(attributeBinding)) {
            this.entityReferencingAttributeBindings.add((SingularAssociationAttributeBinding)attributeBinding);
        }
        this.attributeBindingMap.put(string, attributeBinding);
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public ValueHolder<Class<?>> getProxyInterfaceType() {
        return this.proxyInterfaceType;
    }

    public void setProxyInterfaceType(ValueHolder<Class<?>> valueHolder) {
        this.proxyInterfaceType = valueHolder;
    }

    public String getWhereFilter() {
        return this.whereFilter;
    }

    public void setWhereFilter(String string) {
        this.whereFilter = string;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String string) {
        this.rowId = string;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean bl) {
        this.dynamicUpdate = bl;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean bl) {
        this.dynamicInsert = bl;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean bl) {
        this.selectBeforeUpdate = bl;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    void setSubselectLoadableCollections(boolean bl) {
        this.hasSubselectLoadableCollections = bl;
    }

    public Class<? extends EntityPersister> getCustomEntityPersisterClass() {
        return this.customEntityPersisterClass;
    }

    public void setCustomEntityPersisterClass(Class<? extends EntityPersister> clazz) {
        this.customEntityPersisterClass = clazz;
    }

    public Class<? extends EntityTuplizer> getCustomEntityTuplizerClass() {
        return this.customEntityTuplizerClass;
    }

    public void setCustomEntityTuplizerClass(Class<? extends EntityTuplizer> clazz) {
        this.customEntityTuplizerClass = clazz;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean bl) {
        this.isAbstract = bl;
    }

    public Set<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    public void addSynchronizedTableNames(Collection<String> collection) {
        this.synchronizedTableNames.addAll(collection);
    }

    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    public void setJpaEntityName(String string) {
        this.jpaEntityName = string;
    }

    public String getCustomLoaderName() {
        return this.customLoaderName;
    }

    public void setCustomLoaderName(String string) {
        this.customLoaderName = string;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public void setCustomInsert(CustomSQL customSQL) {
        this.customInsert = customSQL;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public void setCustomUpdate(CustomSQL customSQL) {
        this.customUpdate = customSQL;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    public void setCustomDelete(CustomSQL customSQL) {
        this.customDelete = customSQL;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EntityBinding");
        stringBuilder.append("{entity=").append(this.entity != null ? this.entity.getName() : "not set");
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public BasicAttributeBinding makeBasicAttributeBinding(SingularAttribute singularAttribute) {
        return this.makeSimpleAttributeBinding(singularAttribute, false, false);
    }

    private BasicAttributeBinding makeSimpleAttributeBinding(SingularAttribute singularAttribute, boolean bl, boolean bl2) {
        BasicAttributeBinding basicAttributeBinding = new BasicAttributeBinding(this, singularAttribute, bl, bl2);
        this.registerAttributeBinding(singularAttribute.getName(), basicAttributeBinding);
        return basicAttributeBinding;
    }

    @Override
    public ComponentAttributeBinding makeComponentAttributeBinding(SingularAttribute singularAttribute) {
        ComponentAttributeBinding componentAttributeBinding = new ComponentAttributeBinding((AttributeBindingContainer)this, singularAttribute);
        this.registerAttributeBinding(singularAttribute.getName(), componentAttributeBinding);
        return componentAttributeBinding;
    }

    @Override
    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(SingularAttribute singularAttribute) {
        ManyToOneAttributeBinding manyToOneAttributeBinding = new ManyToOneAttributeBinding((AttributeBindingContainer)this, singularAttribute);
        this.registerAttributeBinding(singularAttribute.getName(), manyToOneAttributeBinding);
        return manyToOneAttributeBinding;
    }

    @Override
    public BagBinding makeBagAttributeBinding(PluralAttribute pluralAttribute, CollectionElementNature collectionElementNature) {
        Helper.checkPluralAttributeNature(pluralAttribute, PluralAttributeNature.BAG);
        BagBinding bagBinding = new BagBinding(this, pluralAttribute, collectionElementNature);
        this.registerAttributeBinding(pluralAttribute.getName(), bagBinding);
        return bagBinding;
    }

    @Override
    public SetBinding makeSetAttributeBinding(PluralAttribute pluralAttribute, CollectionElementNature collectionElementNature) {
        Helper.checkPluralAttributeNature(pluralAttribute, PluralAttributeNature.SET);
        SetBinding setBinding = new SetBinding(this, pluralAttribute, collectionElementNature);
        this.registerAttributeBinding(pluralAttribute.getName(), setBinding);
        return setBinding;
    }

    @Override
    public AttributeBinding locateAttributeBinding(String string) {
        return this.attributeBindingMap.get(string);
    }

    @Override
    public Iterable<AttributeBinding> attributeBindings() {
        return this.attributeBindingMap.values();
    }

    public int getAttributeBindingClosureSpan() {
        return this.superEntityBinding != null ? this.superEntityBinding.getAttributeBindingClosureSpan() + this.attributeBindingMap.size() : this.attributeBindingMap.size();
    }

    public Iterable<AttributeBinding> getAttributeBindingClosure() {
        Iterable<AttributeBinding> iterable;
        if (this.superEntityBinding != null) {
            ArrayList arrayList = new ArrayList(2);
            arrayList.add(this.superEntityBinding.getAttributeBindingClosure());
            arrayList.add(this.attributeBindings());
            iterable = new JoinedIterable<AttributeBinding>(arrayList);
        } else {
            iterable = this.attributeBindings();
        }
        return iterable;
    }

    public Iterable<AttributeBinding> getSubEntityAttributeBindingClosure() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getAttributeBindingClosure());
        for (EntityBinding entityBinding : this.getPreOrderSubEntityBindingClosure()) {
            arrayList.add(entityBinding.attributeBindings());
        }
        return new JoinedIterable<AttributeBinding>(arrayList);
    }

    public void setJpaCallbackClasses(List<JpaCallbackClass> list) {
        this.jpaCallbackClasses = list;
    }

    public Iterable<JpaCallbackClass> getJpaCallbackClasses() {
        return this.jpaCallbackClasses;
    }
}

