/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AbstractSingularAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.Helper;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SetBinding;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Component;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.source.MetaAttributeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttributeBinding
extends AbstractSingularAttributeBinding
implements AttributeBindingContainer {
    private final String path;
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private SingularAttribute parentReference;
    private MetaAttributeContext metaAttributeContext;

    public ComponentAttributeBinding(AttributeBindingContainer attributeBindingContainer, SingularAttribute singularAttribute) {
        super(attributeBindingContainer, singularAttribute);
        this.path = attributeBindingContainer.getPathBase() + '.' + singularAttribute.getName();
    }

    @Override
    public EntityBinding seekEntityBinding() {
        return this.getContainer().seekEntityBinding();
    }

    @Override
    public String getPathBase() {
        return this.path;
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.getComponent();
    }

    public Component getComponent() {
        return (Component)this.getAttribute().getSingularAttributeType();
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    @Override
    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    @Override
    public AttributeBinding locateAttributeBinding(String string) {
        return this.attributeBindingMap.get(string);
    }

    @Override
    public Iterable<AttributeBinding> attributeBindings() {
        return this.attributeBindingMap.values();
    }

    @Override
    protected void checkValueBinding() {
    }

    @Override
    public BasicAttributeBinding makeBasicAttributeBinding(SingularAttribute singularAttribute) {
        BasicAttributeBinding basicAttributeBinding = new BasicAttributeBinding(this, singularAttribute, this.isNullable(), this.isAlternateUniqueKey());
        this.registerAttributeBinding(singularAttribute.getName(), basicAttributeBinding);
        return basicAttributeBinding;
    }

    protected void registerAttributeBinding(String string, AttributeBinding attributeBinding) {
        this.attributeBindingMap.put(string, attributeBinding);
    }

    @Override
    public ComponentAttributeBinding makeComponentAttributeBinding(SingularAttribute singularAttribute) {
        ComponentAttributeBinding componentAttributeBinding = new ComponentAttributeBinding((AttributeBindingContainer)this, singularAttribute);
        this.registerAttributeBinding(singularAttribute.getName(), componentAttributeBinding);
        return componentAttributeBinding;
    }

    @Override
    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(SingularAttribute singularAttribute) {
        ManyToOneAttributeBinding manyToOneAttributeBinding = new ManyToOneAttributeBinding((AttributeBindingContainer)this, singularAttribute);
        this.registerAttributeBinding(singularAttribute.getName(), manyToOneAttributeBinding);
        return manyToOneAttributeBinding;
    }

    @Override
    public BagBinding makeBagAttributeBinding(PluralAttribute pluralAttribute, CollectionElementNature collectionElementNature) {
        Helper.checkPluralAttributeNature(pluralAttribute, PluralAttributeNature.BAG);
        BagBinding bagBinding = new BagBinding(this, pluralAttribute, collectionElementNature);
        this.registerAttributeBinding(pluralAttribute.getName(), bagBinding);
        return bagBinding;
    }

    @Override
    public SetBinding makeSetAttributeBinding(PluralAttribute pluralAttribute, CollectionElementNature collectionElementNature) {
        Helper.checkPluralAttributeNature(pluralAttribute, PluralAttributeNature.SET);
        SetBinding setBinding = new SetBinding(this, pluralAttribute, collectionElementNature);
        this.registerAttributeBinding(pluralAttribute.getName(), setBinding);
        return setBinding;
    }

    @Override
    public Class<?> getClassReference() {
        return this.getComponent().getClassReference();
    }

    public SingularAttribute getParentReference() {
        return this.parentReference;
    }

    public void setParentReference(SingularAttribute singularAttribute) {
        this.parentReference = singularAttribute;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }
}

