/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AbstractSingularAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.KeyValueBinding;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.source.MetaAttributeContext;

public class BasicAttributeBinding
extends AbstractSingularAttributeBinding
implements KeyValueBinding {
    private String unsavedValue;
    private PropertyGeneration generation;
    private boolean includedInOptimisticLocking;
    private boolean forceNonNullable;
    private boolean forceUnique;
    private boolean keyCascadeDeleteEnabled;
    private MetaAttributeContext metaAttributeContext;

    BasicAttributeBinding(AttributeBindingContainer attributeBindingContainer, SingularAttribute singularAttribute, boolean bl, boolean bl2) {
        super(attributeBindingContainer, singularAttribute);
        this.forceNonNullable = bl;
        this.forceUnique = bl2;
    }

    public boolean isAssociation() {
        return false;
    }

    public String getUnsavedValue() {
        return this.unsavedValue;
    }

    public void setUnsavedValue(String string) {
        this.unsavedValue = string;
    }

    public PropertyGeneration getGeneration() {
        return this.generation;
    }

    public void setGeneration(PropertyGeneration propertyGeneration) {
        this.generation = propertyGeneration;
    }

    public boolean isIncludedInOptimisticLocking() {
        return this.includedInOptimisticLocking;
    }

    public void setIncludedInOptimisticLocking(boolean bl) {
        this.includedInOptimisticLocking = bl;
    }

    public boolean isKeyCascadeDeleteEnabled() {
        return this.keyCascadeDeleteEnabled;
    }

    public void setKeyCascadeDeleteEnabled(boolean bl) {
        this.keyCascadeDeleteEnabled = bl;
    }

    public boolean forceNonNullable() {
        return this.forceNonNullable;
    }

    public boolean forceUnique() {
        return this.forceUnique;
    }

    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    IdentifierGenerator createIdentifierGenerator(IdGenerator idGenerator, IdentifierGeneratorFactory identifierGeneratorFactory, Properties properties) {
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Schema schema = this.getValue().getTable().getSchema();
        if (schema != null) {
            if (schema.getName().getSchema() != null) {
                properties2.setProperty("schema", schema.getName().getSchema().getName());
            }
            if (schema.getName().getCatalog() != null) {
                properties2.setProperty("catalog", schema.getName().getCatalog().getName());
            }
        }
        properties2.setProperty("entity_name", this.getContainer().seekEntityBinding().getEntity().getName());
        String string = this.getValue().getTable().getQualifiedName(identifierGeneratorFactory.getDialect());
        properties2.setProperty("target_table", string);
        if (this.getSimpleValueSpan() > 1) {
            throw new MappingException("A SimpleAttributeBinding used for an identifier has more than 1 Value: " + this.getAttribute().getName());
        }
        SimpleValue simpleValue = (SimpleValue)this.getValue();
        if (!Column.class.isInstance(simpleValue)) {
            throw new MappingException("Cannot create an IdentifierGenerator because the value is not a column: " + simpleValue.toLoggableString());
        }
        properties2.setProperty("target_column", ((Column)simpleValue).getColumnName().encloseInQuotesIfQuoted(identifierGeneratorFactory.getDialect()));
        properties2.setProperty("identity_tables", string);
        properties2.putAll(idGenerator.getParameters());
        return identifierGeneratorFactory.createIdentifierGenerator(idGenerator.getStrategy(), this.getHibernateTypeDescriptor().getResolvedTypeMapping(), properties2);
    }
}

