/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.SimpleValueBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingularAttributeBinding
extends AbstractAttributeBinding
implements SingularAttributeBinding {
    private Value value;
    private List<SimpleValueBinding> simpleValueBindings = new ArrayList<SimpleValueBinding>();
    private boolean hasDerivedValue;
    private boolean isNullable = true;

    protected AbstractSingularAttributeBinding(AttributeBindingContainer attributeBindingContainer, SingularAttribute singularAttribute) {
        super(attributeBindingContainer, singularAttribute);
    }

    @Override
    public SingularAttribute getAttribute() {
        return (SingularAttribute)super.getAttribute();
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void setSimpleValueBindings(Iterable<SimpleValueBinding> iterable) {
        ArrayList<SimpleValue> arrayList = new ArrayList<SimpleValue>();
        for (SimpleValueBinding object : iterable) {
            this.simpleValueBindings.add(object);
            arrayList.add(object.getSimpleValue());
            this.hasDerivedValue = this.hasDerivedValue || object.isDerived();
            this.isNullable = this.isNullable && object.isNullable();
        }
        if (arrayList.size() == 1) {
            this.value = (Value)arrayList.get(0);
        } else {
            Tuple tuple = ((SimpleValue)arrayList.get(0)).getTable().createTuple(this.getRole());
            for (SimpleValue simpleValue : arrayList) {
                tuple.addValue(simpleValue);
            }
            this.value = tuple;
        }
    }

    private String getRole() {
        return this.getContainer().getPathBase() + '.' + this.getAttribute().getName();
    }

    @Override
    public int getSimpleValueSpan() {
        this.checkValueBinding();
        return this.simpleValueBindings.size();
    }

    protected void checkValueBinding() {
        if (this.value == null) {
            throw new AssertionFailure("No values yet bound!");
        }
    }

    @Override
    public Iterable<SimpleValueBinding> getSimpleValueBindings() {
        return this.simpleValueBindings;
    }

    @Override
    public boolean hasDerivedValue() {
        this.checkValueBinding();
        return this.hasDerivedValue;
    }

    @Override
    public boolean isNullable() {
        this.checkValueBinding();
        return this.isNullable;
    }
}

