/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.AbstractCollectionElement;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.CollectionKey;
import org.hibernate.metamodel.binding.CompositeCollectionElement;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.ManyToAnyCollectionElement;
import org.hibernate.metamodel.binding.ManyToManyCollectionElement;
import org.hibernate.metamodel.binding.OneToManyCollectionElement;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.persister.collection.CollectionPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluralAttributeBinding
extends AbstractAttributeBinding
implements PluralAttributeBinding {
    private final CollectionKey collectionKey;
    private final AbstractCollectionElement collectionElement;
    private Table collectionTable;
    private FetchTiming fetchTiming;
    private FetchStyle fetchStyle;
    private int batchSize = -1;
    private CascadeStyle cascadeStyle;
    private boolean orphanDelete;
    private Caching caching;
    private boolean inverse;
    private boolean mutable = true;
    private Class<? extends CollectionPersister> collectionPersisterClass;
    private String where;
    private String orderBy;
    private boolean sorted;
    private Comparator comparator;
    private String comparatorClassName;
    private String customLoaderName;
    private CustomSQL customSqlInsert;
    private CustomSQL customSqlUpdate;
    private CustomSQL customSqlDelete;
    private CustomSQL customSqlDeleteAll;
    private String referencedPropertyName;
    private final Map filters = new HashMap();
    private final Set<String> synchronizedTables = new HashSet<String>();

    protected AbstractPluralAttributeBinding(AttributeBindingContainer attributeBindingContainer, PluralAttribute pluralAttribute, CollectionElementNature collectionElementNature) {
        super(attributeBindingContainer, pluralAttribute);
        this.collectionKey = new CollectionKey(this);
        this.collectionElement = this.interpretNature(collectionElementNature);
    }

    private AbstractCollectionElement interpretNature(CollectionElementNature collectionElementNature) {
        switch (collectionElementNature) {
            case BASIC: {
                return new BasicCollectionElement(this);
            }
            case COMPOSITE: {
                return new CompositeCollectionElement(this);
            }
            case ONE_TO_MANY: {
                return new OneToManyCollectionElement(this);
            }
            case MANY_TO_MANY: {
                return new ManyToManyCollectionElement(this);
            }
            case MANY_TO_ANY: {
                return new ManyToAnyCollectionElement(this);
            }
        }
        throw new AssertionFailure("Unknown collection element nature : " + (Object)((Object)collectionElementNature));
    }

    @Override
    public PluralAttribute getAttribute() {
        return (PluralAttribute)super.getAttribute();
    }

    @Override
    public boolean isAssociation() {
        return this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_ANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_MANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.ONE_TO_MANY;
    }

    @Override
    public TableSpecification getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table table) {
        this.collectionTable = table;
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.collectionKey;
    }

    @Override
    public AbstractCollectionElement getCollectionElement() {
        return this.collectionElement;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void setCascadeStyles(Iterable<CascadeStyle> iterable) {
        ArrayList<CascadeStyle> arrayList = new ArrayList<CascadeStyle>();
        for (CascadeStyle cascadeStyle : iterable) {
            if (cascadeStyle != CascadeStyle.NONE) {
                arrayList.add(cascadeStyle);
            }
            if (cascadeStyle != CascadeStyle.DELETE_ORPHAN && cascadeStyle != CascadeStyle.ALL_DELETE_ORPHAN) continue;
            this.orphanDelete = true;
        }
        this.cascadeStyle = arrayList.isEmpty() ? CascadeStyle.NONE : (arrayList.size() == 1 ? (CascadeStyle)arrayList.get(0) : new CascadeStyle.MultipleCascadeStyle(arrayList.toArray(new CascadeStyle[arrayList.size()])));
    }

    @Override
    public boolean isOrphanDelete() {
        return this.orphanDelete;
    }

    @Override
    public FetchMode getFetchMode() {
        if (this.getFetchStyle() == FetchStyle.JOIN) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    @Override
    public FetchTiming getFetchTiming() {
        return this.fetchTiming;
    }

    @Override
    public void setFetchTiming(FetchTiming fetchTiming) {
        this.fetchTiming = fetchTiming;
    }

    @Override
    public FetchStyle getFetchStyle() {
        return this.fetchStyle;
    }

    @Override
    public void setFetchStyle(FetchStyle fetchStyle) {
        this.fetchStyle = fetchStyle;
    }

    @Override
    public String getCustomLoaderName() {
        return this.customLoaderName;
    }

    public void setCustomLoaderName(String string) {
        this.customLoaderName = string;
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return this.customSqlInsert;
    }

    public void setCustomSqlInsert(CustomSQL customSQL) {
        this.customSqlInsert = customSQL;
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return this.customSqlUpdate;
    }

    public void setCustomSqlUpdate(CustomSQL customSQL) {
        this.customSqlUpdate = customSQL;
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return this.customSqlDelete;
    }

    public void setCustomSqlDelete(CustomSQL customSQL) {
        this.customSqlDelete = customSQL;
    }

    @Override
    public CustomSQL getCustomSqlDeleteAll() {
        return this.customSqlDeleteAll;
    }

    public void setCustomSqlDeleteAll(CustomSQL customSQL) {
        this.customSqlDeleteAll = customSQL;
    }

    @Override
    public Class<? extends CollectionPersister> getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void setCollectionPersisterClass(Class<? extends CollectionPersister> clazz) {
        this.collectionPersisterClass = clazz;
    }

    @Override
    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        this.caching = caching;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String string) {
        this.orderBy = string;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public void addFilter(String string, String string2) {
        this.filters.put(string, string2);
    }

    @Override
    public Map getFilterMap() {
        return this.filters;
    }
}

