/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.source.MetaAttributeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeBinding
implements AttributeBinding {
    private final AttributeBindingContainer container;
    private final Attribute attribute;
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final Set<SingularAssociationAttributeBinding> entityReferencingAttributeBindings = new HashSet<SingularAssociationAttributeBinding>();
    private boolean includedInOptimisticLocking;
    private boolean isLazy;
    private String propertyAccessorName;
    private boolean isAlternateUniqueKey;
    private MetaAttributeContext metaAttributeContext;

    protected AbstractAttributeBinding(AttributeBindingContainer attributeBindingContainer, Attribute attribute) {
        this.container = attributeBindingContainer;
        this.attribute = attribute;
    }

    @Override
    public AttributeBindingContainer getContainer() {
        return this.container;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    @Override
    public boolean isBasicPropertyAccessor() {
        return this.propertyAccessorName == null || "property".equals(this.propertyAccessorName);
    }

    @Override
    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    @Override
    public void setPropertyAccessorName(String string) {
        this.propertyAccessorName = string;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.includedInOptimisticLocking;
    }

    @Override
    public void setIncludedInOptimisticLocking(boolean bl) {
        this.includedInOptimisticLocking = bl;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.isAlternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean bl) {
        this.isAlternateUniqueKey = bl;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean bl) {
        this.isLazy = bl;
    }

    @Override
    public void addEntityReferencingAttributeBinding(SingularAssociationAttributeBinding singularAssociationAttributeBinding) {
        this.entityReferencingAttributeBindings.add(singularAssociationAttributeBinding);
    }

    @Override
    public Set<SingularAssociationAttributeBinding> getEntityReferencingAttributeBindings() {
        return Collections.unmodifiableSet(this.entityReferencingAttributeBindings);
    }

    @Override
    public void validate() {
        if (!this.entityReferencingAttributeBindings.isEmpty()) {
            // empty if block
        }
    }
}

