/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.jaxb.JaxbRoot;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.SourceType;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataBuilder;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.MappingNotFoundException;
import org.hibernate.metamodel.source.internal.JaxbHelper;
import org.hibernate.metamodel.source.internal.MetadataBuilderImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataSources {
    private static final Logger LOG = Logger.getLogger(MetadataSources.class);
    private List<JaxbRoot> jaxbRootList = new ArrayList<JaxbRoot>();
    private LinkedHashSet<Class<?>> annotatedClasses = new LinkedHashSet();
    private LinkedHashSet<String> annotatedPackages = new LinkedHashSet();
    private final JaxbHelper jaxbHelper;
    private final ServiceRegistry serviceRegistry;
    private final EntityResolver entityResolver;
    private final NamingStrategy namingStrategy;
    private final MetadataBuilderImpl metadataBuilder;

    public MetadataSources(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, EJB3DTDEntityResolver.INSTANCE, EJB3NamingStrategy.INSTANCE);
    }

    public MetadataSources(ServiceRegistry serviceRegistry, EntityResolver entityResolver, NamingStrategy namingStrategy) {
        this.serviceRegistry = serviceRegistry;
        this.entityResolver = entityResolver;
        this.namingStrategy = namingStrategy;
        this.jaxbHelper = new JaxbHelper(this);
        this.metadataBuilder = new MetadataBuilderImpl(this);
    }

    public List<JaxbRoot> getJaxbRootList() {
        return this.jaxbRootList;
    }

    public Iterable<String> getAnnotatedPackages() {
        return this.annotatedPackages;
    }

    public Iterable<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public MetadataBuilder getMetadataBuilder() {
        return this.metadataBuilder;
    }

    public Metadata buildMetadata() {
        return this.getMetadataBuilder().buildMetadata();
    }

    public MetadataSources addAnnotatedClass(Class clazz) {
        this.annotatedClasses.add(clazz);
        return this;
    }

    public MetadataSources addPackage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The specified package name cannot be null");
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        this.annotatedPackages.add(string);
        return this;
    }

    public MetadataSources addResource(String string) {
        LOG.tracef("reading mappings from resource : %s", (Object)string);
        Origin origin = new Origin(SourceType.RESOURCE, string);
        InputStream inputStream = this.classLoaderService().locateResourceStream(string);
        if (inputStream == null) {
            throw new MappingNotFoundException(origin);
        }
        this.add(inputStream, origin, true);
        return this;
    }

    private ClassLoaderService classLoaderService() {
        return this.serviceRegistry.getService(ClassLoaderService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxbRoot add(InputStream inputStream, Origin origin, boolean bl) {
        try {
            JaxbRoot jaxbRoot = this.jaxbHelper.unmarshal(inputStream, origin);
            this.jaxbRootList.add(jaxbRoot);
            JaxbRoot jaxbRoot2 = jaxbRoot;
            return jaxbRoot2;
        }
        finally {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOG.trace("Was unable to close input stream");
                }
            }
        }
    }

    public MetadataSources addClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The specified class cannot be null");
        }
        LOG.debugf("adding resource mappings from class convention : %s", (Object)clazz.getName());
        String string = clazz.getName().replace('.', '/') + ".hbm.xml";
        this.addResource(string);
        return this;
    }

    public MetadataSources addFile(String string) {
        return this.addFile(new File(string));
    }

    public MetadataSources addFile(File file) {
        String string = file.getAbsolutePath();
        LOG.tracef("reading mappings from file : %s", (Object)string);
        Origin origin = new Origin(SourceType.FILE, string);
        try {
            this.add(new FileInputStream(file), origin, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MappingNotFoundException(fileNotFoundException, origin);
        }
        return this;
    }

    public MetadataSources addCacheableFile(String string) {
        return this;
    }

    public MetadataSources addCacheableFile(File file) {
        return this;
    }

    public MetadataSources addInputStream(InputStream inputStream) {
        this.add(inputStream, new Origin(SourceType.INPUT_STREAM, "<unknown>"), false);
        return this;
    }

    public MetadataSources addURL(URL uRL) {
        String string = uRL.toExternalForm();
        LOG.debugf("Reading mapping document from URL : %s", (Object)string);
        Origin origin = new Origin(SourceType.URL, string);
        try {
            this.add(uRL.openStream(), origin, true);
        }
        catch (IOException iOException) {
            throw new MappingNotFoundException("Unable to open url stream [" + string + "]", iOException, origin);
        }
        return this;
    }

    public MetadataSources addDocument(Document document) {
        Origin origin = new Origin(SourceType.DOM, "<unknown>");
        JaxbRoot jaxbRoot = this.jaxbHelper.unmarshal(document, origin);
        this.jaxbRootList.add(jaxbRoot);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataSources addJar(File file) {
        LOG.debugf("Seeking mapping documents in jar file : %s", (Object)file.getName());
        Origin origin = new Origin(SourceType.JAR, file.getAbsolutePath());
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                    LOG.tracef("found mapping document : %s", (Object)zipEntry.getName());
                    try {
                        this.add(jarFile.getInputStream(zipEntry), origin, true);
                    }
                    catch (Exception exception) {
                        throw new MappingException("could not read mapping documents", exception, origin);
                        return this;
                    }
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            throw new MappingNotFoundException(iOException, origin);
        }
    }

    public MetadataSources addDirectory(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.addDirectory(file2);
                continue;
            }
            if (!file2.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file2);
        }
        return this;
    }
}

