/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;

public abstract class ToOne
extends SimpleValue
implements Fetchable {
    private FetchMode fetchMode;
    protected String referencedPropertyName;
    private String referencedEntityName;
    private boolean embedded;
    private boolean lazy = true;
    protected boolean unwrapProxy;
    protected boolean referenceToPrimaryKey = true;

    protected ToOne(Mappings mappings, Table table) {
        super(mappings, table);
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    public abstract void createForeignKey() throws MappingException;

    public abstract Type getType() throws MappingException;

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public void setReferencedPropertyName(String string) {
        this.referencedPropertyName = string == null ? null : string.intern();
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string == null ? null : string.intern();
    }

    public void setTypeUsingReflection(String string, String string2) throws MappingException {
        if (this.referencedEntityName == null) {
            this.referencedEntityName = ReflectHelper.reflectedPropertyClass(string, string2).getName();
        }
    }

    public boolean isTypeSpecified() {
        return this.referencedEntityName != null;
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    @Deprecated
    public boolean isEmbedded() {
        return this.embedded;
    }

    @Deprecated
    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("association must specify the referenced entity");
        }
        return super.isValid(mapping);
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    public void setUnwrapProxy(boolean bl) {
        this.unwrapProxy = bl;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referenceToPrimaryKey;
    }

    public void setReferenceToPrimaryKey(boolean bl) {
        this.referenceToPrimaryKey = bl;
    }
}

