/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class Table
implements RelationalModel,
Serializable {
    private String name;
    private String schema;
    private String catalog;
    private Map columns = new LinkedHashMap();
    private KeyValue idValue;
    private PrimaryKey primaryKey;
    private Map indexes = new LinkedHashMap();
    private Map foreignKeys = new LinkedHashMap();
    private Map<String, UniqueKey> uniqueKeys = new LinkedHashMap<String, UniqueKey>();
    private int uniqueInteger;
    private boolean quoted;
    private boolean schemaQuoted;
    private boolean catalogQuoted;
    private List checkConstraints = new ArrayList();
    private String rowId;
    private String subselect;
    private boolean isAbstract;
    private boolean hasDenormalizedTables = false;
    private String comment;
    private int sizeOfUniqueKeyMapOnLastCleanse = 0;

    public Table() {
    }

    public Table(String string) {
        this();
        this.setName(string);
    }

    public String getQualifiedName(Dialect dialect, String string, String string2) {
        if (this.subselect != null) {
            return "( " + this.subselect + " )";
        }
        String string3 = this.getQuotedName(dialect);
        String string4 = this.schema == null ? string2 : this.getQuotedSchema(dialect);
        String string5 = this.catalog == null ? string : this.getQuotedCatalog(dialect);
        return Table.qualify(string5, string4, string3);
    }

    public static String qualify(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append('.');
        }
        if (string2 != null) {
            stringBuilder.append(string2).append('.');
        }
        return stringBuilder.append(string3).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quoted ? "`" + this.name + "`" : this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name;
    }

    public String getQuotedSchema() {
        return this.schemaQuoted ? "`" + this.schema + "`" : this.schema;
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schemaQuoted ? dialect.openQuote() + this.schema + dialect.closeQuote() : this.schema;
    }

    public String getQuotedCatalog() {
        return this.catalogQuoted ? "`" + this.catalog + "`" : this.catalog;
    }

    public String getQuotedCatalog(Dialect dialect) {
        return this.catalogQuoted ? dialect.openQuote() + this.catalog + dialect.closeQuote() : this.catalog;
    }

    public void setName(String string) {
        if (string.charAt(0) == '`') {
            this.quoted = true;
            this.name = string.substring(1, string.length() - 1);
        } else {
            this.name = string;
        }
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column column2 = (Column)this.columns.get(column.getCanonicalName());
        return column.equals(column2) ? column2 : null;
    }

    public Column getColumn(int n) {
        Iterator iterator = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iterator.next();
        }
        return (Column)iterator.next();
    }

    public void addColumn(Column column) {
        Column column2 = this.getColumn(column);
        if (column2 == null) {
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = column2.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.values().iterator();
    }

    public Iterator getIndexIterator() {
        return this.indexes.values().iterator();
    }

    public Iterator getForeignKeyIterator() {
        return this.foreignKeys.values().iterator();
    }

    public Iterator getUniqueKeyIterator() {
        return this.getUniqueKeys().values().iterator();
    }

    Map getUniqueKeys() {
        this.cleanseUniqueKeyMapIfNeeded();
        return this.uniqueKeys;
    }

    private void cleanseUniqueKeyMapIfNeeded() {
        if (this.uniqueKeys.size() == this.sizeOfUniqueKeyMapOnLastCleanse) {
            return;
        }
        this.cleanseUniqueKeyMap();
        this.sizeOfUniqueKeyMapOnLastCleanse = this.uniqueKeys.size();
    }

    private void cleanseUniqueKeyMap() {
        if (this.uniqueKeys.isEmpty()) {
            return;
        }
        if (this.uniqueKeys.size() == 1) {
            Map.Entry<String, UniqueKey> entry = this.uniqueKeys.entrySet().iterator().next();
            if (this.isSameAsPrimaryKeyColumns(entry.getValue())) {
                this.uniqueKeys.remove(entry.getKey());
            }
        } else {
            Iterator<Map.Entry<String, UniqueKey>> iterator = this.uniqueKeys.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, UniqueKey> entry = iterator.next();
                UniqueKey uniqueKey = entry.getValue();
                boolean bl = false;
                for (UniqueKey uniqueKey2 : this.uniqueKeys.values()) {
                    if (entry.getValue() == uniqueKey2 || !uniqueKey2.getColumns().containsAll(uniqueKey.getColumns()) || !uniqueKey.getColumns().containsAll(uniqueKey2.getColumns())) continue;
                    bl = true;
                    break;
                }
                if (this.isSameAsPrimaryKeyColumns(entry.getValue())) {
                    bl = true;
                }
                if (!bl) continue;
                iterator.remove();
            }
        }
    }

    private boolean isSameAsPrimaryKeyColumns(UniqueKey uniqueKey) {
        if (this.primaryKey == null || !this.primaryKey.columnIterator().hasNext()) {
            return false;
        }
        return this.primaryKey.getColumns().containsAll(uniqueKey.getColumns()) && uniqueKey.getColumns().containsAll(this.primaryKey.getColumns());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.catalog == null ? 0 : (this.isCatalogQuoted() ? this.catalog.hashCode() : this.catalog.toLowerCase().hashCode()));
        n = 31 * n + (this.name == null ? 0 : (this.isQuoted() ? this.name.hashCode() : this.name.toLowerCase().hashCode()));
        n = 31 * n + (this.schema == null ? 0 : (this.isSchemaQuoted() ? this.schema.hashCode() : this.schema.toLowerCase().hashCode()));
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Table && this.equals((Table)object);
    }

    public boolean equals(Table table) {
        if (null == table) {
            return false;
        }
        if (this == table) {
            return true;
        }
        return this.isQuoted() ? this.name.equals(table.getName()) : !(!this.name.equalsIgnoreCase(table.getName()) || this.schema == null && table.getSchema() != null || this.schema != null && !(this.isSchemaQuoted() ? this.schema.equals(table.getSchema()) : this.schema.equalsIgnoreCase(table.getSchema())) || this.catalog == null && table.getCatalog() != null || this.catalog != null && !(this.isCatalogQuoted() ? this.catalog.equals(table.getCatalog()) : this.catalog.equalsIgnoreCase(table.getCatalog())));
    }

    public void validateColumns(Dialect dialect, Mapping mapping, TableMetadata tableMetadata) {
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(column.getName());
            if (columnMetadata == null) {
                throw new HibernateException("Missing column: " + column.getName() + " in " + Table.qualify(tableMetadata.getCatalog(), tableMetadata.getSchema(), tableMetadata.getName()));
            }
            boolean bl = column.getSqlType(dialect, mapping).toLowerCase().startsWith(columnMetadata.getTypeName().toLowerCase()) || columnMetadata.getTypeCode() == column.getSqlTypeCode(mapping);
            if (bl) continue;
            throw new HibernateException("Wrong column type in " + Table.qualify(tableMetadata.getCatalog(), tableMetadata.getSchema(), tableMetadata.getName()) + " for column " + column.getName() + ". Found: " + columnMetadata.getTypeName().toLowerCase() + ", expected: " + column.getSqlType(dialect, mapping));
        }
    }

    public Iterator sqlAlterStrings(Dialect dialect, Mapping mapping, TableMetadata tableMetadata, String string, String string2) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder("alter table ").append(this.getQualifiedName(dialect, string, string2)).append(' ').append(dialect.getAddColumnString());
        Iterator iterator = this.getColumnIterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string3;
            Column column = (Column)iterator.next();
            ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(column.getName());
            if (columnMetadata != null) continue;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.toString()).append(' ').append(column.getQuotedName(dialect)).append(' ').append(column.getSqlType(dialect, mapping));
            String string4 = column.getDefaultValue();
            if (string4 != null) {
                stringBuilder2.append(" default ").append(string4);
            }
            if (column.isNullable()) {
                stringBuilder2.append(dialect.getNullColumnString());
            } else {
                stringBuilder2.append(" not null");
            }
            if (column.isUnique()) {
                string3 = Constraint.generateName("UK_", this, column);
                UniqueKey uniqueKey = this.getOrCreateUniqueKey(string3);
                uniqueKey.addColumn(column);
                stringBuilder2.append(dialect.getUniqueDelegate().applyUniqueToColumn(column));
            }
            if (column.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                stringBuilder2.append(" check(").append(column.getCheckConstraint()).append(")");
            }
            if ((string3 = column.getComment()) != null) {
                stringBuilder2.append(dialect.getColumnComment(string3));
            }
            arrayList.add(stringBuilder2.toString());
        }
        return arrayList.iterator();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public String sqlTemporaryTableCreateString(Dialect dialect, Mapping mapping) throws HibernateException {
        StringBuilder stringBuilder = new StringBuilder(dialect.getCreateTemporaryTableString()).append(' ').append(this.name).append(" (");
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            stringBuilder.append(column.getQuotedName(dialect)).append(' ');
            stringBuilder.append(column.getSqlType(dialect, mapping));
            if (column.isNullable()) {
                stringBuilder.append(dialect.getNullColumnString());
            } else {
                stringBuilder.append(" not null");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") ");
        stringBuilder.append(dialect.getCreateTemporaryTablePostfix());
        return stringBuilder.toString();
    }

    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(this.hasPrimaryKey() ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(this.getQualifiedName(dialect, string, string2)).append(" (");
        boolean bl = this.idValue != null && this.idValue.isIdentityColumn(mapping.getIdentifierGeneratorFactory(), dialect);
        String string3 = null;
        if (this.hasPrimaryKey() && bl) {
            string3 = ((Column)this.getPrimaryKey().getColumnIterator().next()).getQuotedName(dialect);
        }
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            String string4;
            object = (Column)iterator.next();
            stringBuilder.append(((Column)object).getQuotedName(dialect)).append(' ');
            if (bl && ((Column)object).getQuotedName(dialect).equals(string3)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    stringBuilder.append(((Column)object).getSqlType(dialect, mapping));
                }
                stringBuilder.append(' ').append(dialect.getIdentityColumnString(((Column)object).getSqlTypeCode(mapping)));
            } else {
                stringBuilder.append(((Column)object).getSqlType(dialect, mapping));
                string4 = ((Column)object).getDefaultValue();
                if (string4 != null) {
                    stringBuilder.append(" default ").append(string4);
                }
                if (((Column)object).isNullable()) {
                    stringBuilder.append(dialect.getNullColumnString());
                } else {
                    stringBuilder.append(" not null");
                }
            }
            if (((Column)object).isUnique()) {
                string4 = Constraint.generateName("UK_", this, new Column[]{object});
                UniqueKey uniqueKey = this.getOrCreateUniqueKey(string4);
                uniqueKey.addColumn((Column)object);
                stringBuilder.append(dialect.getUniqueDelegate().applyUniqueToColumn((Column)object));
            }
            if (((Column)object).hasCheckConstraint() && dialect.supportsColumnCheck()) {
                stringBuilder.append(" check (").append(((Column)object).getCheckConstraint()).append(")");
            }
            if ((string4 = ((Column)object).getComment()) != null) {
                stringBuilder.append(dialect.getColumnComment(string4));
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        if (this.hasPrimaryKey()) {
            stringBuilder.append(", ").append(this.getPrimaryKey().sqlConstraintString(dialect));
        }
        stringBuilder.append(dialect.getUniqueDelegate().applyUniquesToTable(this));
        if (dialect.supportsTableCheck()) {
            object = this.checkConstraints.iterator();
            while (object.hasNext()) {
                stringBuilder.append(", check (").append(object.next()).append(')');
            }
        }
        stringBuilder.append(')');
        if (this.comment != null) {
            stringBuilder.append(dialect.getTableComment(this.comment));
        }
        return stringBuilder.append(dialect.getTableTypeString()).toString();
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        return dialect.getDropTableString(this.getQualifiedName(dialect, string, string2));
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Index getOrCreateIndex(String string) {
        Index index = (Index)this.indexes.get(string);
        if (index == null) {
            index = new Index();
            index.setName(string);
            index.setTable(this);
            this.indexes.put(string, index);
        }
        return index;
    }

    public Index getIndex(String string) {
        return (Index)this.indexes.get(string);
    }

    public Index addIndex(Index index) {
        Index index2 = (Index)this.indexes.get(index.getName());
        if (index2 != null) {
            throw new MappingException("Index " + index.getName() + " already exists!");
        }
        this.indexes.put(index.getName(), index);
        return index;
    }

    public UniqueKey addUniqueKey(UniqueKey uniqueKey) {
        UniqueKey uniqueKey2 = this.uniqueKeys.get(uniqueKey.getName());
        if (uniqueKey2 != null) {
            throw new MappingException("UniqueKey " + uniqueKey.getName() + " already exists!");
        }
        this.uniqueKeys.put(uniqueKey.getName(), uniqueKey);
        return uniqueKey;
    }

    public UniqueKey createUniqueKey(List list) {
        String string = Constraint.generateName("UK_", this, list);
        UniqueKey uniqueKey = this.getOrCreateUniqueKey(string);
        uniqueKey.addColumns(list.iterator());
        return uniqueKey;
    }

    public UniqueKey getUniqueKey(String string) {
        return this.uniqueKeys.get(string);
    }

    public UniqueKey getOrCreateUniqueKey(String string) {
        UniqueKey uniqueKey = this.uniqueKeys.get(string);
        if (uniqueKey == null) {
            uniqueKey = new UniqueKey();
            uniqueKey.setName(string);
            uniqueKey.setTable(this);
            this.uniqueKeys.put(string, uniqueKey);
        }
        return uniqueKey;
    }

    public void createForeignKeys() {
    }

    public ForeignKey createForeignKey(String string, List list, String string2) {
        return this.createForeignKey(string, list, string2, null);
    }

    public ForeignKey createForeignKey(String string, List list, String string2, List list2) {
        ForeignKeyKey foreignKeyKey = new ForeignKeyKey(list, string2, list2);
        ForeignKey foreignKey = (ForeignKey)this.foreignKeys.get(foreignKeyKey);
        if (foreignKey == null) {
            foreignKey = new ForeignKey();
            foreignKey.setTable(this);
            foreignKey.setReferencedEntityName(string2);
            foreignKey.addColumns(list.iterator());
            if (list2 != null) {
                foreignKey.addReferencedColumns(list2.iterator());
            }
            if (string != null) {
                foreignKey.setName(string);
            } else {
                foreignKey.setName(Constraint.generateName(foreignKey.generatedConstraintNamePrefix(), this, list));
            }
            this.foreignKeys.put(foreignKeyKey, foreignKey);
        }
        if (string != null) {
            foreignKey.setName(string);
        }
        return foreignKey;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        if (string != null && string.charAt(0) == '`') {
            this.schemaQuoted = true;
            this.schema = string.substring(1, string.length() - 1);
        } else {
            this.schema = string;
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        if (string != null && string.charAt(0) == '`') {
            this.catalogQuoted = true;
            this.catalog = string.substring(1, string.length() - 1);
        } else {
            this.catalog = string;
        }
    }

    public void setUniqueInteger(int n) {
        this.uniqueInteger = n;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    public void setIdentifierValue(KeyValue keyValue) {
        this.idValue = keyValue;
    }

    public KeyValue getIdentifierValue() {
        return this.idValue;
    }

    public boolean isSchemaQuoted() {
        return this.schemaQuoted;
    }

    public boolean isCatalogQuoted() {
        return this.catalogQuoted;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean bl) {
        this.quoted = bl;
    }

    public void addCheckConstraint(String string) {
        this.checkConstraints.add(string);
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String string) {
        this.rowId = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName()).append('(');
        if (this.getCatalog() != null) {
            stringBuilder.append(this.getCatalog() + ".");
        }
        if (this.getSchema() != null) {
            stringBuilder.append(this.getSchema() + ".");
        }
        stringBuilder.append(this.getName()).append(')');
        return stringBuilder.toString();
    }

    public String getSubselect() {
        return this.subselect;
    }

    public void setSubselect(String string) {
        this.subselect = string;
    }

    public boolean isSubselect() {
        return this.subselect != null;
    }

    public boolean isAbstractUnionTable() {
        return this.hasDenormalizedTables() && this.isAbstract;
    }

    public boolean hasDenormalizedTables() {
        return this.hasDenormalizedTables;
    }

    void setHasDenormalizedTables() {
        this.hasDenormalizedTables = true;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPhysicalTable() {
        return !this.isSubselect() && !this.isAbstractUnionTable();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Iterator getCheckConstraintsIterator() {
        return this.checkConstraints.iterator();
    }

    public Iterator sqlCommentStrings(Dialect dialect, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dialect.supportsCommentOn()) {
            Object object;
            String string3;
            String string4 = this.getQualifiedName(dialect, string, string2);
            String string5 = string3 = this.schema == null ? string2 : this.getQuotedSchema(dialect);
            if (this.comment != null) {
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(this.comment, string3, this.getQuotedName(dialect), null));
                } else {
                    object = new StringBuilder().append("comment on table ").append(string4).append(" is '").append(this.comment).append("'");
                    arrayList.add(((StringBuilder)object).toString());
                }
            }
            object = this.getColumnIterator();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                String string6 = column.getComment();
                if (string6 == null) continue;
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string6, string3, this.getQuotedName(dialect), column.getQuotedName(dialect)));
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("comment on column ").append(string4).append('.').append(column.getQuotedName(dialect)).append(" is '").append(string6).append("'");
                arrayList.add(stringBuilder.toString());
            }
        }
        return arrayList.iterator();
    }

    private String generateSqlServerComment(String string, String string2, String string3, String string4) {
        if (string2 == null || string2.length() == 0) {
            string2 = "dbo";
        }
        StringBuffer stringBuffer = new StringBuffer().append("exec sp_addextendedproperty ");
        stringBuffer.append("@name = ").append("N'MS_Description', ").append("@value = N'").append(string.replaceAll("\n", "\r\n")).append("', ");
        stringBuffer.append("@level0type = ").append("N'Schema', ").append("@level0name = N'").append(string2).append("', ");
        stringBuffer.append("@level1type = ").append("N'Table', ").append("@level1name = N'").append(string3).append("'");
        if (string4 != null) {
            stringBuffer.append(", ");
            stringBuffer.append("@level2type = ").append("N'Column', ").append("@level2name = N'").append(string4).append("'");
        }
        return stringBuffer.toString();
    }

    static class ForeignKeyKey
    implements Serializable {
        String referencedClassName;
        List columns;
        List referencedColumns;

        ForeignKeyKey(List list, String string, List list2) {
            this.referencedClassName = string;
            this.columns = new ArrayList();
            this.columns.addAll(list);
            if (list2 != null) {
                this.referencedColumns = new ArrayList();
                this.referencedColumns.addAll(list2);
            } else {
                this.referencedColumns = Collections.EMPTY_LIST;
            }
        }

        public int hashCode() {
            return this.columns.hashCode() + this.referencedColumns.hashCode();
        }

        public boolean equals(Object object) {
            ForeignKeyKey foreignKeyKey = (ForeignKeyKey)object;
            return foreignKeyKey.columns.equals(this.columns) && foreignKeyKey.referencedClassName.equals(this.referencedClassName) && foreignKeyKey.referencedColumns.equals(this.referencedColumns);
        }
    }
}

