/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public class Subclass
extends PersistentClass {
    private PersistentClass superclass;
    private Class classPersisterClass;
    private final int subclassId;

    public Subclass(PersistentClass persistentClass) {
        this.superclass = persistentClass;
        this.subclassId = persistentClass.nextSubclassId();
    }

    int nextSubclassId() {
        return this.getSuperclass().nextSubclassId();
    }

    public int getSubclassId() {
        return this.subclassId;
    }

    public String getNaturalIdCacheRegionName() {
        return this.getSuperclass().getNaturalIdCacheRegionName();
    }

    public String getCacheConcurrencyStrategy() {
        return this.getSuperclass().getCacheConcurrencyStrategy();
    }

    public RootClass getRootClass() {
        return this.getSuperclass().getRootClass();
    }

    public PersistentClass getSuperclass() {
        return this.superclass;
    }

    public Property getIdentifierProperty() {
        return this.getSuperclass().getIdentifierProperty();
    }

    public Property getDeclaredIdentifierProperty() {
        return null;
    }

    public KeyValue getIdentifier() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean hasIdentifierProperty() {
        return this.getSuperclass().hasIdentifierProperty();
    }

    public Value getDiscriminator() {
        return this.getSuperclass().getDiscriminator();
    }

    public boolean isMutable() {
        return this.getSuperclass().isMutable();
    }

    public boolean isInherited() {
        return true;
    }

    public boolean isPolymorphic() {
        return true;
    }

    public void addProperty(Property property) {
        super.addProperty(property);
        this.getSuperclass().addSubclassProperty(property);
    }

    public void addMappedsuperclassProperty(Property property) {
        super.addMappedsuperclassProperty(property);
        this.getSuperclass().addSubclassProperty(property);
    }

    public void addJoin(Join join) {
        super.addJoin(join);
        this.getSuperclass().addSubclassJoin(join);
    }

    public Iterator getPropertyClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getPropertyClosureIterator(), this.getPropertyIterator());
    }

    public Iterator getTableClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getTableClosureIterator(), new SingletonIterator(this.getTable()));
    }

    public Iterator getKeyClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getKeyClosureIterator(), new SingletonIterator(this.getKey()));
    }

    protected void addSubclassProperty(Property property) {
        super.addSubclassProperty(property);
        this.getSuperclass().addSubclassProperty(property);
    }

    protected void addSubclassJoin(Join join) {
        super.addSubclassJoin(join);
        this.getSuperclass().addSubclassJoin(join);
    }

    protected void addSubclassTable(Table table) {
        super.addSubclassTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public boolean isVersioned() {
        return this.getSuperclass().isVersioned();
    }

    public Property getVersion() {
        return this.getSuperclass().getVersion();
    }

    public Property getDeclaredVersion() {
        return null;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.getSuperclass().hasEmbeddedIdentifier();
    }

    public Class getEntityPersisterClass() {
        if (this.classPersisterClass == null) {
            return this.getSuperclass().getEntityPersisterClass();
        }
        return this.classPersisterClass;
    }

    public Table getRootTable() {
        return this.getSuperclass().getRootTable();
    }

    public KeyValue getKey() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean isExplicitPolymorphism() {
        return this.getSuperclass().isExplicitPolymorphism();
    }

    public void setSuperclass(PersistentClass persistentClass) {
        this.superclass = persistentClass;
    }

    public String getWhere() {
        return this.getSuperclass().getWhere();
    }

    public boolean isJoinedSubclass() {
        return this.getTable() != this.getRootTable();
    }

    public void createForeignKey() {
        if (!this.isJoinedSubclass()) {
            throw new AssertionFailure("not a joined-subclass");
        }
        this.getKey().createForeignKeyOfEntity(this.getSuperclass().getEntityName());
    }

    public void setEntityPersisterClass(Class clazz) {
        this.classPersisterClass = clazz;
    }

    public boolean isLazyPropertiesCacheable() {
        return this.getSuperclass().isLazyPropertiesCacheable();
    }

    public int getJoinClosureSpan() {
        return this.getSuperclass().getJoinClosureSpan() + super.getJoinClosureSpan();
    }

    public int getPropertyClosureSpan() {
        return this.getSuperclass().getPropertyClosureSpan() + super.getPropertyClosureSpan();
    }

    public Iterator getJoinClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getJoinClosureIterator(), super.getJoinClosureIterator());
    }

    public boolean isClassOrSuperclassJoin(Join join) {
        return super.isClassOrSuperclassJoin(join) || this.getSuperclass().isClassOrSuperclassJoin(join);
    }

    public boolean isClassOrSuperclassTable(Table table) {
        return super.isClassOrSuperclassTable(table) || this.getSuperclass().isClassOrSuperclassTable(table);
    }

    public Table getTable() {
        return this.getSuperclass().getTable();
    }

    public boolean isForceDiscriminator() {
        return this.getSuperclass().isForceDiscriminator();
    }

    public boolean isDiscriminatorInsertable() {
        return this.getSuperclass().isDiscriminatorInsertable();
    }

    public Set getSynchronizedTables() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.synchronizedTables);
        hashSet.addAll(this.getSuperclass().getSynchronizedTables());
        return hashSet;
    }

    public Object accept(PersistentClassVisitor persistentClassVisitor) {
        return persistentClassVisitor.accept(this);
    }

    public List getFilters() {
        ArrayList arrayList = new ArrayList(super.getFilters());
        arrayList.addAll(this.getSuperclass().getFilters());
        return arrayList;
    }

    public boolean hasSubselectLoadableCollections() {
        return super.hasSubselectLoadableCollections() || this.getSuperclass().hasSubselectLoadableCollections();
    }

    public String getTuplizerImplClassName(EntityMode entityMode) {
        String string = super.getTuplizerImplClassName(entityMode);
        if (string == null) {
            string = this.getSuperclass().getTuplizerImplClassName(entityMode);
        }
        return string;
    }

    public Map getTuplizerMap() {
        Map map = super.getTuplizerMap();
        Map map2 = this.getSuperclass().getTuplizerMap();
        if (map == null && map2 == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Component getIdentifierMapper() {
        return this.superclass.getIdentifierMapper();
    }

    public int getOptimisticLockMode() {
        return this.superclass.getOptimisticLockMode();
    }
}

