/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;

public class Set
extends Collection {
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
    }

    public Set(Mappings mappings, PersistentClass persistentClass) {
        super(mappings, persistentClass);
    }

    public boolean isSet() {
        return true;
    }

    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return this.getMappings().getTypeResolver().getTypeFactory().sortedSet(this.getRole(), this.getReferencedPropertyName(), this.getComparator());
        }
        if (this.hasOrder()) {
            return this.getMappings().getTypeResolver().getTypeFactory().orderedSet(this.getRole(), this.getReferencedPropertyName());
        }
        return this.getMappings().getTypeResolver().getTypeFactory().set(this.getRole(), this.getReferencedPropertyName());
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.addColumns(this.getKey().getColumnIterator());
            Iterator iterator = this.getElement().getColumnIterator();
            while (iterator.hasNext()) {
                Column column;
                Object e = iterator.next();
                if (!(e instanceof Column) || (column = (Column)e).isNullable()) continue;
                primaryKey.addColumn(column);
            }
            if (primaryKey.getColumnSpan() != this.getKey().getColumnSpan()) {
                this.getCollectionTable().setPrimaryKey(primaryKey);
            }
        }
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }
}

