/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class RootClass
extends PersistentClass
implements TableOwner {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, RootClass.class.getName());
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private Property identifierProperty;
    private KeyValue identifier;
    private Property version;
    private boolean polymorphic;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private String naturalIdCacheRegionName;
    private boolean lazyPropertiesCacheable = true;
    private Value discriminator;
    private boolean mutable = true;
    private boolean embeddedIdentifier = false;
    private boolean explicitPolymorphism;
    private Class entityPersisterClass;
    private boolean forceDiscriminator = false;
    private String where;
    private Table table;
    private boolean discriminatorInsertable = true;
    private int nextSubclassId = 0;
    private Property declaredIdentifierProperty;
    private Property declaredVersion;

    int nextSubclassId() {
        return ++this.nextSubclassId;
    }

    public int getSubclassId() {
        return 0;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public Property getIdentifierProperty() {
        return this.identifierProperty;
    }

    public Property getDeclaredIdentifierProperty() {
        return this.declaredIdentifierProperty;
    }

    public void setDeclaredIdentifierProperty(Property property) {
        this.declaredIdentifierProperty = property;
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public Value getDiscriminator() {
        return this.discriminator;
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean bl) {
        this.polymorphic = bl;
    }

    public RootClass getRootClass() {
        return this;
    }

    public Iterator getPropertyClosureIterator() {
        return this.getPropertyIterator();
    }

    public Iterator getTableClosureIterator() {
        return new SingletonIterator(this.getTable());
    }

    public Iterator getKeyClosureIterator() {
        return new SingletonIterator(this.getKey());
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public Property getVersion() {
        return this.version;
    }

    public Property getDeclaredVersion() {
        return this.declaredVersion;
    }

    public void setDeclaredVersion(Property property) {
        this.declaredVersion = property;
    }

    public void setVersion(Property property) {
        this.version = property;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.embeddedIdentifier;
    }

    public Class getEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    public Table getRootTable() {
        return this.getTable();
    }

    public void setEntityPersisterClass(Class clazz) {
        this.entityPersisterClass = clazz;
    }

    public PersistentClass getSuperclass() {
        return null;
    }

    public KeyValue getKey() {
        return this.getIdentifier();
    }

    public void setDiscriminator(Value value) {
        this.discriminator = value;
    }

    public void setEmbeddedIdentifier(boolean bl) {
        this.embeddedIdentifier = bl;
    }

    public void setExplicitPolymorphism(boolean bl) {
        this.explicitPolymorphism = bl;
    }

    public void setIdentifier(KeyValue keyValue) {
        this.identifier = keyValue;
    }

    public void setIdentifierProperty(Property property) {
        this.identifierProperty = property;
        property.setPersistentClass(this);
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public boolean isDiscriminatorInsertable() {
        return this.discriminatorInsertable;
    }

    public void setDiscriminatorInsertable(boolean bl) {
        this.discriminatorInsertable = bl;
    }

    public boolean isForceDiscriminator() {
        return this.forceDiscriminator;
    }

    public void setForceDiscriminator(boolean bl) {
        this.forceDiscriminator = bl;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("identifier mapping has wrong number of columns: " + this.getEntityName() + " type: " + this.getIdentifier().getType().getName());
        }
        this.checkCompositeIdentifier();
    }

    private void checkCompositeIdentifier() {
        Component component;
        if (this.getIdentifier() instanceof Component && !(component = (Component)this.getIdentifier()).isDynamic()) {
            Class clazz = component.getComponentClass();
            String string = clazz.getName();
            if (clazz != null && !ReflectHelper.overridesEquals(clazz)) {
                LOG.compositeIdClassDoesNotOverrideEquals(string);
            }
            if (!ReflectHelper.overridesHashCode(clazz)) {
                LOG.compositeIdClassDoesNotOverrideHashCode(string);
            }
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new MappingException("Composite-id class must implement Serializable: " + string);
            }
        }
    }

    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    public void setCacheConcurrencyStrategy(String string) {
        this.cacheConcurrencyStrategy = string;
    }

    public String getCacheRegionName() {
        return this.cacheRegionName == null ? this.getEntityName() : this.cacheRegionName;
    }

    public void setCacheRegionName(String string) {
        this.cacheRegionName = string;
    }

    public String getNaturalIdCacheRegionName() {
        return this.naturalIdCacheRegionName;
    }

    public void setNaturalIdCacheRegionName(String string) {
        this.naturalIdCacheRegionName = string;
    }

    public boolean isLazyPropertiesCacheable() {
        return this.lazyPropertiesCacheable;
    }

    public void setLazyPropertiesCacheable(boolean bl) {
        this.lazyPropertiesCacheable = bl;
    }

    public boolean isJoinedSubclass() {
        return false;
    }

    public Set getSynchronizedTables() {
        return this.synchronizedTables;
    }

    public Set getIdentityTables() {
        HashSet<Table> hashSet = new HashSet<Table>();
        Iterator iterator = this.getSubclassClosureIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)iterator.next();
            if (persistentClass.isAbstract() != null && persistentClass.isAbstract().booleanValue()) continue;
            hashSet.add(persistentClass.getIdentityTable());
        }
        return hashSet;
    }

    public Object accept(PersistentClassVisitor persistentClassVisitor) {
        return persistentClassVisitor.accept(this);
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }
}

