/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class Property
implements Serializable,
MetaAttributable {
    private String name;
    private Value value;
    private String cascade;
    private boolean updateable = true;
    private boolean insertable = true;
    private boolean selectable = true;
    private boolean optimisticLocked = true;
    private PropertyGeneration generation = PropertyGeneration.NEVER;
    private String propertyAccessorName;
    private boolean lazy;
    private boolean optional;
    private String nodeName;
    private Map metaAttributes;
    private PersistentClass persistentClass;
    private boolean naturalIdentifier;
    private boolean lob;

    public boolean isBackRef() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public Type getType() throws MappingException {
        return this.value.getType();
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public Iterator getColumnIterator() {
        return this.value.getColumnIterator();
    }

    public String getName() {
        return this.name;
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isPrimitive(Class clazz) {
        return this.getGetter(clazz).getReturnType().isPrimitive();
    }

    public CascadeStyle getCascadeStyle() throws MappingException {
        Type type = this.value.getType();
        if (type.isComponentType()) {
            return Property.getCompositeCascadeStyle((CompositeType)type, this.cascade);
        }
        if (type.isCollectionType()) {
            return Property.getCollectionCascadeStyle(((Collection)this.value).getElement().getType(), this.cascade);
        }
        return Property.getCascadeStyle(this.cascade);
    }

    private static CascadeStyle getCompositeCascadeStyle(CompositeType compositeType, String string) {
        if (compositeType.isAnyType()) {
            return Property.getCascadeStyle(string);
        }
        int n = compositeType.getSubtypes().length;
        for (int i = 0; i < n; ++i) {
            if (compositeType.getCascadeStyle(i) == CascadeStyle.NONE) continue;
            return CascadeStyle.ALL;
        }
        return Property.getCascadeStyle(string);
    }

    private static CascadeStyle getCollectionCascadeStyle(Type type, String string) {
        if (type.isComponentType()) {
            return Property.getCompositeCascadeStyle((CompositeType)type, string);
        }
        return Property.getCascadeStyle(string);
    }

    private static CascadeStyle getCascadeStyle(String string) {
        if (string == null || string.equals("none")) {
            return CascadeStyle.NONE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        CascadeStyle[] cascadeStyleArray = new CascadeStyle[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            cascadeStyleArray[n++] = CascadeStyle.getCascadeStyle(stringTokenizer.nextToken());
        }
        return new CascadeStyle.MultipleCascadeStyle(cascadeStyleArray);
    }

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String string) {
        this.cascade = string;
    }

    public void setName(String string) {
        this.name = string == null ? null : string.intern();
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean isUpdateable() {
        return this.updateable && !ArrayHelper.isAllFalse(this.value.getColumnUpdateability());
    }

    public boolean isInsertable() {
        boolean[] blArray = this.value.getColumnInsertability();
        return this.insertable && (blArray.length == 0 || !ArrayHelper.isAllFalse(blArray));
    }

    public PropertyGeneration getGeneration() {
        return this.generation;
    }

    public void setGeneration(PropertyGeneration propertyGeneration) {
        this.generation = propertyGeneration;
    }

    public void setUpdateable(boolean bl) {
        this.updateable = bl;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    public void setPropertyAccessorName(String string) {
        this.propertyAccessorName = string;
    }

    boolean isNullable() {
        return this.value == null || this.value.isNullable();
    }

    public boolean isBasicPropertyAccessor() {
        return this.propertyAccessorName == null || "property".equals(this.propertyAccessorName);
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public MetaAttribute getMetaAttribute(String string) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(string);
    }

    public void setMetaAttributes(Map map) {
        this.metaAttributes = map;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getValue().isValid(mapping);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.name + ')';
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public boolean isLazy() {
        if (this.value instanceof ToOne) {
            ToOne toOne = (ToOne)this.value;
            return toOne.isLazy() && toOne.isUnwrapProxy();
        }
        return this.lazy;
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public void setOptimisticLocked(boolean bl) {
        this.optimisticLocked = bl;
    }

    public boolean isOptional() {
        return this.optional || this.isNullable();
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getAccessorPropertyName(EntityMode entityMode) {
        return this.getName();
    }

    public Getter getGetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(clazz).getGetter(clazz, this.name);
    }

    public Setter getSetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(clazz).getSetter(clazz, this.name);
    }

    public PropertyAccessor getPropertyAccessor(Class clazz) throws MappingException {
        return PropertyAccessorFactory.getPropertyAccessor(clazz, this.getPropertyAccessorName());
    }

    public boolean isNaturalIdentifier() {
        return this.naturalIdentifier;
    }

    public void setNaturalIdentifier(boolean bl) {
        this.naturalIdentifier = bl;
    }

    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean bl) {
        this.lob = bl;
    }
}

