/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ManyToOne
extends ToOne {
    private boolean ignoreNotFound;
    private boolean isLogicalOneToOne;

    public ManyToOne(Mappings mappings, Table table) {
        super(mappings, table);
    }

    public Type getType() throws MappingException {
        return this.getMappings().getTypeResolver().getTypeFactory().manyToOne(this.getReferencedEntityName(), this.referenceToPrimaryKey, this.getReferencedPropertyName(), this.isLazy(), this.isUnwrapProxy(), this.isIgnoreNotFound(), this.isLogicalOneToOne);
    }

    public void createForeignKey() throws MappingException {
        if (this.referencedPropertyName == null && !this.hasFormula()) {
            this.createForeignKeyOfEntity(((EntityType)this.getType()).getAssociatedEntityName());
        }
    }

    public void createPropertyRefConstraints(Map map) {
        if (this.referencedPropertyName != null) {
            PersistentClass persistentClass = (PersistentClass)map.get(this.getReferencedEntityName());
            Property property = persistentClass.getReferencedProperty(this.getReferencedPropertyName());
            if (property == null) {
                throw new MappingException("Could not find property " + this.getReferencedPropertyName() + " on " + this.getReferencedEntityName());
            }
            if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
                Serializable serializable;
                ArrayList<Column> arrayList = new ArrayList<Column>();
                Iterator iterator = property.getColumnIterator();
                while (iterator.hasNext()) {
                    serializable = (Column)iterator.next();
                    arrayList.add((Column)serializable);
                }
                serializable = this.getTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), ((EntityType)this.getType()).getAssociatedEntityName(), arrayList);
                ((ForeignKey)serializable).setCascadeDeleteEnabled(this.isCascadeDeleteEnabled());
            }
        }
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean bl) {
        this.ignoreNotFound = bl;
    }

    public void markAsLogicalOneToOne() {
        this.isLogicalOneToOne = true;
    }

    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }
}

