/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;

public class Join
implements Serializable {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    private ArrayList properties = new ArrayList();
    private ArrayList declaredProperties = new ArrayList();
    private Table table;
    private KeyValue key;
    private PersistentClass persistentClass;
    private boolean sequentialSelect;
    private boolean inverse;
    private boolean optional;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;

    public void addProperty(Property property) {
        this.properties.add(property);
        this.declaredProperties.add(property);
        property.setPersistentClass(this.getPersistentClass());
    }

    public void addMappedsuperclassProperty(Property property) {
        this.properties.add(property);
        property.setPersistentClass(this.getPersistentClass());
    }

    public Iterator getDeclaredPropertyIterator() {
        return this.declaredProperties.iterator();
    }

    public boolean containsProperty(Property property) {
        return this.properties.contains(property);
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public KeyValue getKey() {
        return this.key;
    }

    public void setKey(KeyValue keyValue) {
        this.key = keyValue;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void createForeignKey() {
        this.getKey().createForeignKeyOfEntity(this.persistentClass.getEntityName());
    }

    public void createPrimaryKey() {
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKey.setTable(this.table);
        primaryKey.setName(PK_ALIAS.toAliasString(this.table.getName()));
        this.table.setPrimaryKey(primaryKey);
        primaryKey.addColumns(this.getKey().getColumnIterator());
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public void setCustomSQLInsert(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLInsert = string;
        this.customInsertCallable = bl;
        this.insertCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLUpdate = string;
        this.customUpdateCallable = bl;
        this.updateCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLDelete = string;
        this.customDeleteCallable = bl;
        this.deleteCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    public boolean isSequentialSelect() {
        return this.sequentialSelect;
    }

    public void setSequentialSelect(boolean bl) {
        this.sequentialSelect = bl;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.table.toString() + ')';
    }

    public boolean isLazy() {
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.isLazy()) continue;
            return false;
        }
        return true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }
}

