/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.Table;

public class Index
implements RelationalModel,
Serializable {
    private Table table;
    private List columns = new ArrayList();
    private String name;

    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) throws HibernateException {
        return Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumnIterator(), false, string, string2);
    }

    public static String buildSqlDropIndexString(Dialect dialect, Table table, String string, String string2, String string3) {
        return "drop index " + StringHelper.qualify(table.getQualifiedName(dialect, string2, string3), string);
    }

    public static String buildSqlCreateIndexString(Dialect dialect, String string, Table table, Iterator iterator, boolean bl, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("create").append(bl ? " unique" : "").append(" index ").append(dialect.qualifyIndexName() ? string : StringHelper.unqualify(string)).append(" on ").append(table.getQualifiedName(dialect, string2, string3)).append(" (");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            stringBuilder.append(((Column)iterator2.next()).getQuotedName(dialect));
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String sqlConstraintString(Dialect dialect) {
        StringBuilder stringBuilder = new StringBuilder(" index (");
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((Column)iterator.next()).getQuotedName(dialect));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(')').toString();
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        return "drop index " + StringHelper.qualify(this.table.getQualifiedName(dialect, string, string2), this.name);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addColumn((Column)iterator.next());
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getName() + ")";
    }
}

