/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class DenormalizedTable
extends Table {
    private final Table includedTable;

    public DenormalizedTable(Table table) {
        this.includedTable = table;
        table.setHasDenormalizedTables();
    }

    public void createForeignKeys() {
        this.includedTable.createForeignKeys();
        Iterator iterator = this.includedTable.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            this.createForeignKey(Constraint.generateName(foreignKey.generatedConstraintNamePrefix(), (Table)this, foreignKey.getColumns()), foreignKey.getColumns(), foreignKey.getReferencedEntityName());
        }
    }

    public Column getColumn(Column column) {
        Column column2 = super.getColumn(column);
        if (column2 != null) {
            return column2;
        }
        return this.includedTable.getColumn(column);
    }

    public Iterator getColumnIterator() {
        return new JoinedIterator(this.includedTable.getColumnIterator(), super.getColumnIterator());
    }

    public boolean containsColumn(Column column) {
        return super.containsColumn(column) || this.includedTable.containsColumn(column);
    }

    public PrimaryKey getPrimaryKey() {
        return this.includedTable.getPrimaryKey();
    }

    public Iterator getUniqueKeyIterator() {
        Iterator iterator = this.includedTable.getUniqueKeyIterator();
        while (iterator.hasNext()) {
            UniqueKey uniqueKey = (UniqueKey)iterator.next();
            this.createUniqueKey(uniqueKey.getColumns());
        }
        return this.getUniqueKeys().values().iterator();
    }

    public Iterator getIndexIterator() {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        Iterator iterator = this.includedTable.getIndexIterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            Index index2 = new Index();
            index2.setName(this.getName() + index.getName());
            index2.setTable(this);
            index2.addColumns(index.getColumnIterator());
            arrayList.add(index2);
        }
        return new JoinedIterator(arrayList.iterator(), super.getIndexIterator());
    }
}

