/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constraint
implements RelationalModel,
Serializable {
    private String name;
    private final ArrayList columns = new ArrayList();
    private Table table;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static String generateName(String string, Table table, Column ... columnArray) {
        StringBuilder stringBuilder = new StringBuilder("table`" + table.getName() + "`");
        Column[] columnArray2 = (Column[])columnArray.clone();
        Arrays.sort(columnArray2, ColumnComparator.INSTANCE);
        for (Column column : columnArray2) {
            String string2 = column == null ? "" : column.getName();
            stringBuilder.append("column`" + string2 + "`");
        }
        return string + Constraint.hashedName(stringBuilder.toString());
    }

    public static String generateName(String string, Table table, List<Column> list) {
        return Constraint.generateName(string, table, list.toArray(new Column[list.size()]));
    }

    public static String hashedName(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray);
            return bigInteger.toString(35);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HibernateException("Unable to generate a hashed Constraint name!", noSuchAlgorithmException);
        }
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator iterator) {
        while (iterator.hasNext()) {
            Selectable selectable = (Selectable)iterator.next();
            if (selectable.isFormula()) continue;
            this.addColumn((Column)selectable);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Column getColumn(int n) {
        return (Column)this.columns.get(n);
    }

    public Iterator columnIterator() {
        return this.columns.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isGenerated(Dialect dialect) {
        return true;
    }

    @Override
    public String sqlDropString(Dialect dialect, String string, String string2) {
        if (this.isGenerated(dialect)) {
            return "alter table " + this.getTable().getQualifiedName(dialect, string, string2) + " drop constraint " + dialect.quote(this.getName());
        }
        return null;
    }

    @Override
    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) {
        if (this.isGenerated(dialect)) {
            String string3 = this.sqlConstraintString(dialect, this.getName(), string, string2);
            StringBuilder stringBuilder = new StringBuilder("alter table ").append(this.getTable().getQualifiedName(dialect, string, string2)).append(string3);
            return stringBuilder.toString();
        }
        return null;
    }

    public List getColumns() {
        return this.columns;
    }

    public abstract String sqlConstraintString(Dialect var1, String var2, String var3, String var4);

    public String toString() {
        return this.getClass().getName() + '(' + this.getTable().getName() + this.getColumns() + ") as " + this.name;
    }

    public abstract String generatedConstraintNamePrefix();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnComparator
    implements Comparator<Column> {
        public static ColumnComparator INSTANCE = new ColumnComparator();

        private ColumnComparator() {
        }

        @Override
        public int compare(Column column, Column column2) {
            return column.getName().compareTo(column2.getName());
        }
    }
}

