/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.property.Setter;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class Component
extends SimpleValue
implements MetaAttributable {
    private ArrayList properties = new ArrayList();
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private Map metaAttributes;
    private String nodeName;
    private boolean isKey;
    private String roleName;
    private Map tuplizerImpls;
    private IdentifierGenerator builtIdentifierGenerator;

    public Component(Mappings mappings, PersistentClass persistentClass) throws MappingException {
        super(mappings, persistentClass.getTable());
        this.owner = persistentClass;
    }

    public Component(Mappings mappings, Component component) throws MappingException {
        super(mappings, component.getTable());
        this.owner = component.getOwner();
    }

    public Component(Mappings mappings, Join join) throws MappingException {
        super(mappings, join.getTable());
        this.owner = join.getPersistentClass();
    }

    public Component(Mappings mappings, Collection collection) throws MappingException {
        super(mappings, collection.getCollectionTable());
        this.owner = collection.getOwner();
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    public int getColumnSpan() {
        int n = 0;
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            n += property.getColumnSpan();
        }
        return n;
    }

    public Iterator getColumnIterator() {
        Iterator[] iteratorArray = new Iterator[this.getPropertySpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            iteratorArray[n++] = ((Property)iterator.next()).getColumnIterator();
        }
        return new JoinedIterator(iteratorArray);
    }

    public void setTypeByReflection(String string, String string2) {
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public Class getComponentClass() throws MappingException {
        try {
            return ReflectHelper.classForName(this.componentClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("component class not found: " + this.componentClassName, classNotFoundException);
        }
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String string) {
        this.componentClassName = string;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public void setOwner(PersistentClass persistentClass) {
        this.owner = persistentClass;
    }

    public void setParentProperty(String string) {
        this.parentProperty = string;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public Type getType() throws MappingException {
        ComponentMetamodel componentMetamodel = new ComponentMetamodel(this);
        TypeFactory typeFactory = this.getMappings().getTypeResolver().getTypeFactory();
        return this.isEmbedded() ? typeFactory.embeddedComponent(componentMetamodel) : typeFactory.component(componentMetamodel);
    }

    public void setTypeUsingReflection(String string, String string2) throws MappingException {
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public MetaAttribute getMetaAttribute(String string) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(string);
    }

    public void setMetaAttributes(Map map) {
        this.metaAttributes = map;
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    public boolean[] getColumnInsertability() {
        boolean[] blArray = new boolean[this.getColumnSpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            boolean[] blArray2 = property.getValue().getColumnInsertability();
            if (property.isInsertable()) {
                System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            }
            n += blArray2.length;
        }
        return blArray;
    }

    public boolean[] getColumnUpdateability() {
        boolean[] blArray = new boolean[this.getColumnSpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            boolean[] blArray2 = property.getValue().getColumnUpdateability();
            if (property.isUpdateable()) {
                System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            }
            n += blArray2.length;
        }
        return blArray;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public boolean hasPojoRepresentation() {
        return this.componentClassName != null;
    }

    public void addTuplizer(EntityMode entityMode, String string) {
        if (this.tuplizerImpls == null) {
            this.tuplizerImpls = new HashMap();
        }
        this.tuplizerImpls.put(entityMode, string);
    }

    public String getTuplizerImplClassName(EntityMode entityMode) {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return (String)this.tuplizerImpls.get((Object)entityMode);
    }

    public Map getTuplizerMap() {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.tuplizerImpls);
    }

    public Property getProperty(String string) throws MappingException {
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(string)) continue;
            return property;
        }
        throw new MappingException("component property not found: " + string);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.properties.toString() + ')';
    }

    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String string, String string2, RootClass rootClass) throws MappingException {
        if (this.builtIdentifierGenerator == null) {
            this.builtIdentifierGenerator = this.buildIdentifierGenerator(identifierGeneratorFactory, dialect, string, string2, rootClass);
        }
        return this.builtIdentifierGenerator;
    }

    private IdentifierGenerator buildIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String string, String string2, RootClass rootClass) throws MappingException {
        boolean bl;
        boolean bl2 = bl = !"assigned".equals(this.getIdentifierGeneratorStrategy());
        if (bl) {
            return super.createIdentifierGenerator(identifierGeneratorFactory, dialect, string, string2, rootClass);
        }
        Class clazz = rootClass.getMappedClass();
        Class clazz2 = rootClass.getIdentifierMapper() != null ? this.resolveComponentClass() : (rootClass.getIdentifierProperty() != null ? this.resolveComponentClass() : clazz);
        StandardGenerationContextLocator standardGenerationContextLocator = new StandardGenerationContextLocator(rootClass.getEntityName());
        CompositeNestedGeneratedValueGenerator compositeNestedGeneratedValueGenerator = new CompositeNestedGeneratedValueGenerator(standardGenerationContextLocator);
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            SimpleValue simpleValue;
            Property property = (Property)iterator.next();
            if (!property.getValue().isSimpleValue() || "assigned".equals((simpleValue = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy())) continue;
            IdentifierGenerator identifierGenerator = simpleValue.createIdentifierGenerator(identifierGeneratorFactory, dialect, string, string2, rootClass);
            compositeNestedGeneratedValueGenerator.addGeneratedValuePlan(new ValueGenerationPlan(property.getName(), identifierGenerator, this.injector(property, clazz2)));
        }
        return compositeNestedGeneratedValueGenerator;
    }

    private Setter injector(Property property, Class clazz) {
        return property.getPropertyAccessor(clazz).getSetter(clazz, property.getName());
    }

    private Class resolveComponentClass() {
        try {
            return this.getComponentClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class ValueGenerationPlan
    implements CompositeNestedGeneratedValueGenerator.GenerationPlan {
        private final String propertyName;
        private final IdentifierGenerator subGenerator;
        private final Setter injector;

        public ValueGenerationPlan(String string, IdentifierGenerator identifierGenerator, Setter setter) {
            this.propertyName = string;
            this.subGenerator = identifierGenerator;
            this.injector = setter;
        }

        public void execute(SessionImplementor sessionImplementor, Object object, Object object2) {
            Serializable serializable = this.subGenerator.generate(sessionImplementor, object);
            this.injector.set(object2, serializable, sessionImplementor.getFactory());
        }

        public void registerPersistentGenerators(Map map) {
            if (PersistentIdentifierGenerator.class.isInstance(this.subGenerator)) {
                map.put(((PersistentIdentifierGenerator)this.subGenerator).generatorKey(), this.subGenerator);
            }
        }
    }

    public static class StandardGenerationContextLocator
    implements CompositeNestedGeneratedValueGenerator.GenerationContextLocator {
        private final String entityName;

        public StandardGenerationContextLocator(String string) {
            this.entityName = string;
        }

        public Serializable locateGenerationContext(SessionImplementor sessionImplementor, Object object) {
            return sessionImplementor.getEntityPersister(this.entityName, object).getIdentifier(object, sessionImplementor);
        }
    }
}

