/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.hql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.hql.internal.ast.QueryTranslatorImpl;
import org.hibernate.hql.internal.ast.tree.AggregatedSelectExpression;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.internal.IteratorImpl;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.Loader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLoader
extends BasicLoader {
    private QueryTranslatorImpl queryTranslator;
    private Queryable[] entityPersisters;
    private String[] entityAliases;
    private String[] sqlAliases;
    private String[] sqlAliasSuffixes;
    private boolean[] includeInSelect;
    private String[] collectionSuffixes;
    private boolean hasScalars;
    private String[][] scalarColumnNames;
    private Type[] queryReturnTypes;
    private final Map<String, String> sqlAliasByEntityAlias = new HashMap<String, String>(8);
    private EntityType[] ownerAssociationTypes;
    private int[] owners;
    private boolean[] entityEagerPropertyFetches;
    private int[] collectionOwners;
    private QueryableCollection[] collectionPersisters;
    private int selectLength;
    private AggregatedSelectExpression aggregatedSelectExpression;
    private String[] queryReturnAliases;
    private LockMode[] defaultLockModes;

    public QueryLoader(QueryTranslatorImpl queryTranslatorImpl, SessionFactoryImplementor sessionFactoryImplementor, SelectClause selectClause) {
        super(sessionFactoryImplementor);
        this.queryTranslator = queryTranslatorImpl;
        this.initialize(selectClause);
        this.postInstantiate();
    }

    private void initialize(SelectClause selectClause) {
        FromElement fromElement;
        int n;
        int n2;
        List list = selectClause.getFromElementsForLoad();
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumnNames = selectClause.getColumnNames();
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.aggregatedSelectExpression = selectClause.getAggregatedSelectExpression();
        this.queryReturnAliases = selectClause.getQueryReturnAliases();
        List list2 = selectClause.getCollectionFromElements();
        if (list2 != null && list2.size() != 0) {
            n2 = list2.size();
            this.collectionPersisters = new QueryableCollection[n2];
            this.collectionOwners = new int[n2];
            this.collectionSuffixes = new String[n2];
            for (n = 0; n < n2; ++n) {
                fromElement = (FromElement)list2.get(n);
                this.collectionPersisters[n] = fromElement.getQueryableCollection();
                this.collectionOwners[n] = list.indexOf(fromElement.getOrigin());
                this.collectionSuffixes[n] = fromElement.getCollectionSuffix();
            }
        }
        n2 = list.size();
        this.entityPersisters = new Queryable[n2];
        this.entityEagerPropertyFetches = new boolean[n2];
        this.entityAliases = new String[n2];
        this.sqlAliases = new String[n2];
        this.sqlAliasSuffixes = new String[n2];
        this.includeInSelect = new boolean[n2];
        this.owners = new int[n2];
        this.ownerAssociationTypes = new EntityType[n2];
        for (n = 0; n < n2; ++n) {
            fromElement = (FromElement)list.get(n);
            this.entityPersisters[n] = (Queryable)fromElement.getEntityPersister();
            if (this.entityPersisters[n] == null) {
                throw new IllegalStateException("No entity persister for " + fromElement.toString());
            }
            this.entityEagerPropertyFetches[n] = fromElement.isAllPropertyFetch();
            this.sqlAliases[n] = fromElement.getTableAlias();
            this.entityAliases[n] = fromElement.getClassAlias();
            this.sqlAliasByEntityAlias.put(this.entityAliases[n], this.sqlAliases[n]);
            this.sqlAliasSuffixes[n] = n2 == 1 ? "" : Integer.toString(n) + "_";
            boolean bl = this.includeInSelect[n] = !fromElement.isFetch();
            if (this.includeInSelect[n]) {
                ++this.selectLength;
            }
            this.owners[n] = -1;
            if (!fromElement.isFetch() || fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null || !fromElement.getDataType().isEntityType()) continue;
            EntityType entityType = (EntityType)fromElement.getDataType();
            if (entityType.isOneToOne()) {
                this.owners[n] = list.indexOf(fromElement.getOrigin());
            }
            this.ownerAssociationTypes[n] = entityType;
        }
        this.defaultLockModes = ArrayHelper.fillArray(LockMode.NONE, n2);
    }

    public AggregatedSelectExpression getAggregatedSelectExpression() {
        return this.aggregatedSelectExpression;
    }

    public final void validateScrollability() throws HibernateException {
        this.queryTranslator.validateScrollability();
    }

    @Override
    protected boolean needsFetchingScroll() {
        return this.queryTranslator.containsCollectionFetches();
    }

    @Override
    public Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    @Override
    public String[] getAliases() {
        return this.sqlAliases;
    }

    public String[] getSqlAliasSuffixes() {
        return this.sqlAliasSuffixes;
    }

    @Override
    public String[] getSuffixes() {
        return this.getSqlAliasSuffixes();
    }

    @Override
    public String[] getCollectionSuffixes() {
        return this.collectionSuffixes;
    }

    @Override
    protected String getQueryIdentifier() {
        return this.queryTranslator.getQueryIdentifier();
    }

    @Override
    public String getSQLString() {
        return this.queryTranslator.getSQLString();
    }

    @Override
    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    @Override
    protected boolean[] getEntityEagerPropertyFetches() {
        return this.entityEagerPropertyFetches;
    }

    @Override
    protected int[] getOwners() {
        return this.owners;
    }

    @Override
    protected EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    @Override
    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    @Override
    protected LockMode[] getLockModes(LockOptions lockOptions) {
        if (lockOptions == null) {
            return this.defaultLockModes;
        }
        if (lockOptions.getAliasLockCount() == 0 && (lockOptions.getLockMode() == null || LockMode.NONE.equals((Object)lockOptions.getLockMode()))) {
            return this.defaultLockModes;
        }
        LockMode[] lockModeArray = new LockMode[this.entityAliases.length];
        for (int i = 0; i < this.entityAliases.length; ++i) {
            LockMode lockMode = lockOptions.getEffectiveLockMode(this.entityAliases[i]);
            if (lockMode == null) {
                lockMode = LockMode.NONE;
            }
            lockModeArray[i] = lockMode;
        }
        return lockModeArray;
    }

    @Override
    protected String applyLocks(String string, QueryParameters queryParameters, Dialect dialect, List<Loader.AfterLoadAction> list) throws QueryException {
        LockOptions lockOptions = queryParameters.getLockOptions();
        if (lockOptions == null || lockOptions.getLockMode() == LockMode.NONE && lockOptions.getAliasLockCount() == 0) {
            return string;
        }
        if (this.shouldUseFollowOnLocking(queryParameters, dialect, list)) {
            return string;
        }
        LockOptions lockOptions2 = new LockOptions(lockOptions.getLockMode());
        HashMap<String, String[]> hashMap = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        lockOptions2.setScope(lockOptions.getScope());
        lockOptions2.setTimeOut(lockOptions.getTimeOut());
        for (Map.Entry<String, String> entry : this.sqlAliasByEntityAlias.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (string3 == null) {
                throw new IllegalArgumentException("could not locate alias to apply lock mode : " + string2);
            }
            QueryNode queryNode = (QueryNode)this.queryTranslator.getSqlAST();
            Lockable lockable = (Lockable)((Object)queryNode.getFromClause().findFromElementByUserOrSqlAlias(string2, string3).getQueryable());
            String string4 = lockable.getRootTableAlias(string3);
            LockMode lockMode = lockOptions.getEffectiveLockMode(string2);
            lockOptions2.setAliasSpecificLockMode(string4, lockMode);
            if (hashMap == null) continue;
            hashMap.put(string4, lockable.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(string, lockOptions2, hashMap);
    }

    @Override
    protected void applyPostLoadLocks(Object[] objectArray, LockMode[] lockModeArray, SessionImplementor sessionImplementor) {
    }

    @Override
    protected boolean upgradeLocks() {
        return true;
    }

    private boolean hasSelectNew() {
        return this.aggregatedSelectExpression != null && this.aggregatedSelectExpression.getResultTransformer() != null;
    }

    @Override
    protected String[] getResultRowAliases() {
        return this.queryReturnAliases;
    }

    @Override
    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        ResultTransformer resultTransformer2 = this.aggregatedSelectExpression == null ? null : this.aggregatedSelectExpression.getResultTransformer();
        return HolderInstantiator.resolveResultTransformer(resultTransformer2, resultTransformer);
    }

    @Override
    protected boolean[] includeInResultRow() {
        boolean[] blArray = this.includeInSelect;
        if (this.hasScalars) {
            blArray = new boolean[this.queryReturnTypes.length];
            Arrays.fill(blArray, true);
        }
        return blArray;
    }

    @Override
    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray2 = this.getResultRow(objectArray, resultSet, sessionImplementor);
        boolean bl = this.hasSelectNew() || resultTransformer != null;
        return !bl && objectArray2.length == 1 ? objectArray2[0] : objectArray2;
    }

    @Override
    protected Object[] getResultRow(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray2;
        if (this.hasScalars) {
            String[][] stringArray = this.scalarColumnNames;
            int n = this.queryReturnTypes.length;
            objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = this.queryReturnTypes[i].nullSafeGet(resultSet, stringArray[i], sessionImplementor, null);
            }
        } else {
            objectArray2 = this.toResultRow(objectArray);
        }
        return objectArray2;
    }

    @Override
    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        HolderInstantiator holderInstantiator = this.buildHolderInstantiator(resultTransformer);
        if (holderInstantiator.isRequired()) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                Object object = holderInstantiator.instantiate(objectArray);
                list.set(i, object);
            }
            if (!this.hasSelectNew() && resultTransformer != null) {
                return resultTransformer.transformList(list);
            }
            return list;
        }
        return list;
    }

    private HolderInstantiator buildHolderInstantiator(ResultTransformer resultTransformer) {
        ResultTransformer resultTransformer2 = this.aggregatedSelectExpression == null ? null : this.aggregatedSelectExpression.getResultTransformer();
        return HolderInstantiator.getHolderInstantiator(resultTransformer2, resultTransformer, this.queryReturnAliases);
    }

    public List list(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        this.checkQuery(queryParameters);
        return this.list(sessionImplementor, queryParameters, this.queryTranslator.getQuerySpaces(), this.queryReturnTypes);
    }

    private void checkQuery(QueryParameters queryParameters) {
        if (this.hasSelectNew() && queryParameters.getResultTransformer() != null) {
            throw new QueryException("ResultTransformer is not allowed for 'select new' queries.");
        }
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        this.checkQuery(queryParameters);
        boolean bl = eventSource.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            if (queryParameters.isCallable()) {
                throw new QueryException("iterate() not supported for callable statements");
            }
            Loader.SqlStatementWrapper sqlStatementWrapper = this.executeQueryStatement(queryParameters, false, Collections.<Loader.AfterLoadAction>emptyList(), eventSource);
            ResultSet resultSet = sqlStatementWrapper.getResultSet();
            PreparedStatement preparedStatement = (PreparedStatement)sqlStatementWrapper.getStatement();
            IteratorImpl iteratorImpl = new IteratorImpl(resultSet, preparedStatement, eventSource, queryParameters.isReadOnly(eventSource), this.queryReturnTypes, this.queryTranslator.getColumnNames(), this.buildHolderInstantiator(queryParameters.getResultTransformer()));
            if (bl) {
                eventSource.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - l);
            }
            return iteratorImpl;
        }
        catch (SQLException sQLException) {
            throw this.getFactory().getSQLExceptionHelper().convert(sQLException, "could not execute query using iterate", this.getSQLString());
        }
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.checkQuery(queryParameters);
        return this.scroll(queryParameters, this.queryReturnTypes, this.buildHolderInstantiator(queryParameters.getResultTransformer()), sessionImplementor);
    }

    private Object[] toResultRow(Object[] objectArray) {
        if (this.selectLength == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[this.selectLength];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            objectArray2[n++] = objectArray[i];
        }
        return objectArray2;
    }

    @Override
    public int[] getNamedParameterLocs(String string) throws QueryException {
        return this.queryTranslator.getParameterTranslations().getNamedParameterSqlLocations(string);
    }

    @Override
    protected int bindParameterValues(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        int n2 = n;
        List<ParameterSpecification> list = this.queryTranslator.getCollectedParameterSpecifications();
        for (ParameterSpecification parameterSpecification : list) {
            n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n2);
        }
        return n2 - n;
    }
}

