/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

class PaddedBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final PaddedBatchingEntityLoaderBuilder INSTANCE = new PaddedBatchingEntityLoaderBuilder();

    PaddedBatchingEntityLoaderBuilder() {
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new PaddedBatchingEntityLoader(outerJoinLoadable, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new PaddedBatchingEntityLoader(outerJoinLoadable, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public static class PaddedBatchingEntityLoader
    extends BatchingEntityLoader {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public PaddedBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.batchSizes = ArrayHelper.getBatchSizes(n);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(outerJoinLoadable, this.batchSizes[i], lockMode, sessionFactoryImplementor, loadQueryInfluencers);
            }
            this.validate(n);
        }

        private void validate(int n) {
            if (this.batchSizes[0] != n) {
                throw new HibernateException("Unexpected batch size spread");
            }
            if (this.batchSizes[this.batchSizes.length - 1] != 1) {
                throw new HibernateException("Unexpected batch size spread");
            }
        }

        public PaddedBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.batchSizes = ArrayHelper.getBatchSizes(n);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(outerJoinLoadable, this.batchSizes[i], lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
            }
            this.validate(n);
        }

        public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), serializable, this.batchSizes[0], this.persister().getEntityMode());
            int n = ArrayHelper.countNonNull(serializableArray);
            if (n <= 1) {
                return ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(serializable, object, sessionImplementor);
            }
            int n2 = this.batchSizes.length - 1;
            int n3 = 0;
            while (n3 < this.batchSizes.length - 1 && this.batchSizes[n3] >= n) {
                n2 = n3++;
            }
            Serializable[] serializableArray2 = new Serializable[this.batchSizes[n2]];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            for (int i = n; i < this.batchSizes[n2]; ++i) {
                serializableArray2[i] = serializable;
            }
            return this.doBatchLoad(serializable, this.loaders[n2], sessionImplementor, serializableArray2, object, lockOptions);
        }
    }
}

