/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

public class LegacyBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final LegacyBatchingEntityLoaderBuilder INSTANCE = new LegacyBatchingEntityLoaderBuilder();

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new LegacyBatchingEntityLoader(outerJoinLoadable, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new LegacyBatchingEntityLoader(outerJoinLoadable, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public static class LegacyBatchingEntityLoader
    extends BatchingEntityLoader
    implements UniqueEntityLoader {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public LegacyBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.batchSizes = ArrayHelper.getBatchSizes(n);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(outerJoinLoadable, this.batchSizes[i], lockMode, sessionFactoryImplementor, loadQueryInfluencers);
            }
        }

        public LegacyBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.batchSizes = ArrayHelper.getBatchSizes(n);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(outerJoinLoadable, this.batchSizes[i], lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
            }
        }

        public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), serializable, this.batchSizes[0], this.persister().getEntityMode());
            for (int i = 0; i < this.batchSizes.length - 1; ++i) {
                int n = this.batchSizes[i];
                if (serializableArray[n - 1] == null) continue;
                Serializable[] serializableArray2 = new Serializable[n];
                System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
                List list = this.loaders[i].loadEntityBatch(sessionImplementor, serializableArray2, this.persister().getIdentifierType(), object, this.persister().getEntityName(), serializable, this.persister(), lockOptions);
                return this.getObjectFromList(list, serializable, sessionImplementor);
            }
            return ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(serializable, object, sessionImplementor);
        }
    }
}

