/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class EntityJoinWalker
extends AbstractEntityJoinWalker {
    private final LockOptions lockOptions = new LockOptions();
    private final int[][] compositeKeyManyToOneTargetIndices;

    public EntityJoinWalker(OuterJoinLoadable outerJoinLoadable, String[] stringArray, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(outerJoinLoadable, sessionFactoryImplementor, loadQueryInfluencers);
        this.lockOptions.setLockMode(lockMode);
        StringBuilder stringBuilder = this.whereString(this.getAlias(), stringArray, n).append(outerJoinLoadable.filterFragment(this.getAlias(), Collections.EMPTY_MAP));
        AssociationInitCallbackImpl associationInitCallbackImpl = new AssociationInitCallbackImpl(sessionFactoryImplementor);
        this.initAll(stringBuilder.toString(), "", this.lockOptions, associationInitCallbackImpl);
        this.compositeKeyManyToOneTargetIndices = associationInitCallbackImpl.resolve();
    }

    public EntityJoinWalker(OuterJoinLoadable outerJoinLoadable, String[] stringArray, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(outerJoinLoadable, sessionFactoryImplementor, loadQueryInfluencers);
        LockOptions.copy(lockOptions, this.lockOptions);
        StringBuilder stringBuilder = this.whereString(this.getAlias(), stringArray, n).append(outerJoinLoadable.filterFragment(this.getAlias(), Collections.EMPTY_MAP));
        AssociationInitCallbackImpl associationInitCallbackImpl = new AssociationInitCallbackImpl(sessionFactoryImplementor);
        this.initAll(stringBuilder.toString(), "", lockOptions, associationInitCallbackImpl);
        this.compositeKeyManyToOneTargetIndices = associationInitCallbackImpl.resolve();
    }

    protected JoinType getJoinType(OuterJoinLoadable outerJoinLoadable, PropertyPath propertyPath, int n, AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle, String string, String[] stringArray, boolean bl, int n2) throws MappingException {
        if (this.lockOptions.getLockMode().greaterThan(LockMode.READ)) {
            return JoinType.NONE;
        }
        if (this.isTooDeep(n2) || associationType.isCollectionType() && this.isTooManyCollections()) {
            return JoinType.NONE;
        }
        if (!this.isJoinedFetchEnabledInMapping(fetchMode, associationType) && !this.isJoinFetchEnabledByProfile(outerJoinLoadable, propertyPath, n)) {
            return JoinType.NONE;
        }
        if (this.isDuplicateAssociation(string, stringArray, associationType)) {
            return JoinType.NONE;
        }
        return this.getJoinType(bl, n2);
    }

    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }

    public int[][] getCompositeKeyManyToOneTargetIndices() {
        return this.compositeKeyManyToOneTargetIndices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssociationInitCallbackImpl
    implements JoinWalker.AssociationInitCallback {
        private final SessionFactoryImplementor factory;
        private final HashMap<String, OuterJoinableAssociation> associationsByAlias = new HashMap();
        private final HashMap<String, Integer> positionsByAlias = new HashMap();
        private final ArrayList<String> aliasesForAssociationsWithCompositesIds = new ArrayList();

        public AssociationInitCallbackImpl(SessionFactoryImplementor sessionFactoryImplementor) {
            this.factory = sessionFactoryImplementor;
        }

        @Override
        public void associationProcessed(OuterJoinableAssociation outerJoinableAssociation, int n) {
            this.associationsByAlias.put(outerJoinableAssociation.getRhsAlias(), outerJoinableAssociation);
            this.positionsByAlias.put(outerJoinableAssociation.getRhsAlias(), n);
            EntityPersister entityPersister = null;
            if (outerJoinableAssociation.getJoinableType().isCollectionType()) {
                entityPersister = ((QueryableCollection)outerJoinableAssociation.getJoinable()).getElementPersister();
            } else if (outerJoinableAssociation.getJoinableType().isEntityType()) {
                entityPersister = (EntityPersister)((Object)outerJoinableAssociation.getJoinable());
            }
            if (entityPersister != null && entityPersister.getIdentifierType().isComponentType() && !entityPersister.getEntityMetamodel().getIdentifierProperty().isEmbedded() && this.hasAssociation((CompositeType)entityPersister.getIdentifierType())) {
                this.aliasesForAssociationsWithCompositesIds.add(outerJoinableAssociation.getRhsAlias());
            }
        }

        private boolean hasAssociation(CompositeType compositeType) {
            for (Type type : compositeType.getSubtypes()) {
                if (type.isEntityType()) {
                    return true;
                }
                if (!type.isComponentType() || !this.hasAssociation((CompositeType)type)) continue;
                return true;
            }
            return false;
        }

        public int[][] resolve() {
            Object object = null;
            for (String string : this.aliasesForAssociationsWithCompositesIds) {
                OuterJoinableAssociation outerJoinableAssociation = this.associationsByAlias.get(string);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                EntityPersister entityPersister = null;
                if (outerJoinableAssociation.getJoinableType().isCollectionType()) {
                    entityPersister = ((QueryableCollection)outerJoinableAssociation.getJoinable()).getElementPersister();
                } else if (outerJoinableAssociation.getJoinableType().isEntityType()) {
                    entityPersister = (EntityPersister)((Object)outerJoinableAssociation.getJoinable());
                }
                this.findKeyManyToOneTargetIndices(arrayList, outerJoinableAssociation, (CompositeType)entityPersister.getIdentifierType());
                if (arrayList.isEmpty()) continue;
                if (object == null) {
                    object = new int[this.associationsByAlias.size()][];
                }
                int n = this.positionsByAlias.get(string);
                object[n] = new int[arrayList.size()];
                int n2 = 0;
                Iterator<Integer> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n3;
                    object[n][n2] = n3 = iterator.next().intValue();
                    ++n2;
                }
            }
            return object;
        }

        private void findKeyManyToOneTargetIndices(ArrayList<Integer> arrayList, OuterJoinableAssociation outerJoinableAssociation, CompositeType compositeType) {
            for (Type type : compositeType.getSubtypes()) {
                if (type.isEntityType()) {
                    Integer n = this.locateKeyManyToOneTargetIndex(outerJoinableAssociation, (EntityType)type);
                    if (n == null) continue;
                    arrayList.add(n);
                    continue;
                }
                if (!type.isComponentType()) continue;
                this.findKeyManyToOneTargetIndices(arrayList, outerJoinableAssociation, (CompositeType)type);
            }
        }

        private Integer locateKeyManyToOneTargetIndex(OuterJoinableAssociation outerJoinableAssociation, EntityType entityType) {
            if (outerJoinableAssociation.getLhsAlias() != null) {
                OuterJoinableAssociation outerJoinableAssociation2 = this.associationsByAlias.get(outerJoinableAssociation.getLhsAlias());
                if (entityType.getAssociatedEntityName(this.factory).equals(outerJoinableAssociation2.getJoinableType().getAssociatedEntityName(this.factory))) {
                    return this.positionsByAlias.get(outerJoinableAssociation2.getRhsAlias());
                }
            }
            for (OuterJoinableAssociation outerJoinableAssociation3 : this.associationsByAlias.values()) {
                if (outerJoinableAssociation3.getLhsAlias() == null || !outerJoinableAssociation3.getLhsAlias().equals(outerJoinableAssociation.getRhsAlias()) || !entityType.equals(outerJoinableAssociation3.getJoinableType())) continue;
                return this.positionsByAlias.get(outerJoinableAssociation3.getLhsAlias());
            }
            return null;
        }
    }
}

