/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class DynamicBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    private static final Logger log = Logger.getLogger(DynamicBatchingEntityLoaderBuilder.class);
    public static final DynamicBatchingEntityLoaderBuilder INSTANCE = new DynamicBatchingEntityLoaderBuilder();

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new DynamicBatchingEntityLoader(outerJoinLoadable, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        return new DynamicBatchingEntityLoader(outerJoinLoadable, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    private static class DynamicEntityLoader
    extends EntityLoader {
        private final String sqlTemplate;
        private final String alias;

        public DynamicEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            this(outerJoinLoadable, n, lockOptions.getLockMode(), sessionFactoryImplementor, loadQueryInfluencers);
        }

        public DynamicEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable, -1, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
            EntityJoinWalker entityJoinWalker = new EntityJoinWalker(outerJoinLoadable, outerJoinLoadable.getIdentifierColumnNames(), -1, lockMode, sessionFactoryImplementor, loadQueryInfluencers){

                protected StringBuilder whereString(String string, String[] stringArray, int n) {
                    return StringHelper.buildBatchFetchRestrictionFragment(string, stringArray, this.getFactory().getDialect());
                }
            };
            this.initFromWalker(entityJoinWalker);
            this.sqlTemplate = entityJoinWalker.getSQLString();
            this.alias = entityJoinWalker.getAlias();
            this.postInstantiate();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("SQL-template for dynamic entity [%s] batch-fetching [%s] : %s", (Object)this.entityName, (Object)lockMode, (Object)this.sqlTemplate);
            }
        }

        protected boolean isSingleRowLoader() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List doEntityBatchFetch(SessionImplementor sessionImplementor, QueryParameters queryParameters, Serializable[] serializableArray) {
            String string = StringHelper.expandBatchIdPlaceholder(this.sqlTemplate, serializableArray, this.alias, this.persister.getKeyColumnNames(), this.getFactory().getDialect());
            PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
            boolean bl = persistenceContext.isDefaultReadOnly();
            if (queryParameters.isReadOnlyInitialized()) {
                persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
            } else {
                queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
            }
            persistenceContext.beforeLoad();
            try {
                List list;
                try {
                    list = this.doTheLoad(string, queryParameters, sessionImplementor);
                }
                finally {
                    persistenceContext.afterLoad();
                }
                persistenceContext.initializeNonLazyCollections();
                log.debug("Done batch load");
                List list2 = list;
                persistenceContext.setDefaultReadOnly(bl);
                return list2;
            }
            catch (Throwable throwable) {
                try {
                    persistenceContext.setDefaultReadOnly(bl);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], serializableArray, sessionImplementor.getFactory()), string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List doTheLoad(String string, QueryParameters queryParameters, SessionImplementor sessionImplementor) throws SQLException {
            RowSelection rowSelection = queryParameters.getRowSelection();
            int n = LimitHelper.hasMaxRows(rowSelection) ? rowSelection.getMaxRows() : Integer.MAX_VALUE;
            ArrayList<Loader.AfterLoadAction> arrayList = new ArrayList<Loader.AfterLoadAction>();
            Loader.SqlStatementWrapper sqlStatementWrapper = this.executeQueryStatement(string, queryParameters, false, arrayList, sessionImplementor);
            ResultSet resultSet = sqlStatementWrapper.getResultSet();
            Statement statement = sqlStatementWrapper.getStatement();
            try {
                List list = this.processResultSet(resultSet, queryParameters, sessionImplementor, false, null, n, arrayList);
                return list;
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(statement);
            }
        }
    }

    public static class DynamicBatchingEntityLoader
    extends BatchingEntityLoader {
        private final int maxBatchSize;
        private final UniqueEntityLoader singleKeyLoader;
        private final DynamicEntityLoader dynamicLoader;

        public DynamicBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.maxBatchSize = n;
            this.singleKeyLoader = new EntityLoader(outerJoinLoadable, 1, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
            this.dynamicLoader = new DynamicEntityLoader(outerJoinLoadable, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
        }

        public DynamicBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
            super(outerJoinLoadable);
            this.maxBatchSize = n;
            this.singleKeyLoader = new EntityLoader(outerJoinLoadable, 1, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
            this.dynamicLoader = new DynamicEntityLoader(outerJoinLoadable, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
        }

        public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
            Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), serializable, this.maxBatchSize, this.persister().getEntityMode());
            int n = ArrayHelper.countNonNull(serializableArray);
            if (n <= 1) {
                return this.singleKeyLoader.load(serializable, object, sessionImplementor);
            }
            Serializable[] serializableArray2 = new Serializable[n];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            if (log.isDebugEnabled()) {
                log.debugf("Batch loading entity: %s", (Object)MessageHelper.infoString(this.persister(), serializableArray2, sessionImplementor.getFactory()));
            }
            QueryParameters queryParameters = this.buildQueryParameters(serializable, serializableArray2, object, lockOptions);
            List list = this.dynamicLoader.doEntityBatchFetch(sessionImplementor, queryParameters, serializableArray2);
            return this.getObjectFromList(list, serializable, sessionImplementor);
        }
    }
}

