/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.entity.DynamicBatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.LegacyBatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.PaddedBatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

public abstract class BatchingEntityLoaderBuilder {
    public static BatchingEntityLoaderBuilder getBuilder(SessionFactoryImplementor sessionFactoryImplementor) {
        switch (sessionFactoryImplementor.getSettings().getBatchFetchStyle()) {
            case PADDED: {
                return PaddedBatchingEntityLoaderBuilder.INSTANCE;
            }
            case DYNAMIC: {
                return DynamicBatchingEntityLoaderBuilder.INSTANCE;
            }
        }
        return LegacyBatchingEntityLoaderBuilder.INSTANCE;
    }

    public UniqueEntityLoader buildLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        if (n <= 1) {
            return new EntityLoader(outerJoinLoadable, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
        }
        return this.buildBatchingLoader(outerJoinLoadable, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected abstract UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable var1, int var2, LockMode var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);

    public UniqueEntityLoader buildLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) {
        if (n <= 1) {
            return new EntityLoader(outerJoinLoadable, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
        }
        return this.buildBatchingLoader(outerJoinLoadable, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected abstract UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable var1, int var2, LockOptions var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);
}

