/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class BatchingEntityLoader
implements UniqueEntityLoader {
    private static final Logger log = Logger.getLogger(BatchingEntityLoader.class);
    private final EntityPersister persister;

    public BatchingEntityLoader(EntityPersister entityPersister) {
        this.persister = entityPersister;
    }

    public EntityPersister persister() {
        return this.persister;
    }

    @Deprecated
    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        return this.load(serializable, object, sessionImplementor, LockOptions.NONE);
    }

    protected QueryParameters buildQueryParameters(Serializable serializable, Serializable[] serializableArray, Object object, LockOptions lockOptions) {
        Object[] objectArray = new Type[serializableArray.length];
        Arrays.fill(objectArray, this.persister().getIdentifierType());
        QueryParameters queryParameters = new QueryParameters();
        queryParameters.setPositionalParameterTypes((Type[])objectArray);
        queryParameters.setPositionalParameterValues(serializableArray);
        queryParameters.setOptionalObject(object);
        queryParameters.setOptionalEntityName(this.persister().getEntityName());
        queryParameters.setOptionalId(serializable);
        queryParameters.setLockOptions(lockOptions);
        return queryParameters;
    }

    protected Object getObjectFromList(List list, Serializable serializable, SessionImplementor sessionImplementor) {
        for (Object e : list) {
            boolean bl = this.persister.getIdentifierType().isEqual(serializable, sessionImplementor.getContextEntityIdentifier(e), sessionImplementor.getFactory());
            if (!bl) continue;
            return e;
        }
        return null;
    }

    protected Object doBatchLoad(Serializable serializable, Loader loader, SessionImplementor sessionImplementor, Serializable[] serializableArray, Object object, LockOptions lockOptions) {
        if (log.isDebugEnabled()) {
            log.debugf("Batch loading entity: %s", (Object)MessageHelper.infoString(this.persister, serializableArray, sessionImplementor.getFactory()));
        }
        QueryParameters queryParameters = this.buildQueryParameters(serializable, serializableArray, object, lockOptions);
        try {
            List list = loader.doQueryAndInitializeNonLazyCollections(sessionImplementor, queryParameters, false);
            log.debug("Done entity batch load");
            return this.getObjectFromList(list, serializable, sessionImplementor);
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not load an entity batch: " + MessageHelper.infoString(this.persister(), serializableArray, sessionImplementor.getFactory()), loader.getSQLString());
        }
    }
}

