/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.EnhancedProjection;
import org.hibernate.criterion.Projection;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.hql.internal.ast.util.SessionFactoryHelper;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.criteria.ComponentCollectionCriteriaInfoProvider;
import org.hibernate.loader.criteria.CriteriaInfoProvider;
import org.hibernate.loader.criteria.EntityCriteriaInfoProvider;
import org.hibernate.loader.criteria.ScalarCollectionCriteriaInfoProvider;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.Type;

public class CriteriaQueryTranslator
implements CriteriaQuery {
    public static final String ROOT_SQL_ALIAS = "this_";
    private CriteriaQuery outerQueryTranslator;
    private final CriteriaImpl rootCriteria;
    private final String rootEntityName;
    private final String rootSQLAlias;
    private int aliasCount = 0;
    private final Map criteriaInfoMap = new LinkedHashMap();
    private final Map nameCriteriaInfoMap = new LinkedHashMap();
    private final Map criteriaSQLAliasMap = new HashMap();
    private final Map aliasCriteriaMap = new HashMap();
    private final Map associationPathCriteriaMap = new LinkedHashMap();
    private final Map<String, JoinType> associationPathJoinTypesMap = new LinkedHashMap<String, JoinType>();
    private final Map withClauseMap = new HashMap();
    private final SessionFactoryImplementor sessionFactory;
    private final SessionFactoryHelper helper;

    public CriteriaQueryTranslator(SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, String string2, CriteriaQuery criteriaQuery) throws HibernateException {
        this(sessionFactoryImplementor, criteriaImpl, string, string2);
        this.outerQueryTranslator = criteriaQuery;
    }

    public CriteriaQueryTranslator(SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, String string2) throws HibernateException {
        this.rootCriteria = criteriaImpl;
        this.rootEntityName = string;
        this.sessionFactory = sessionFactoryImplementor;
        this.rootSQLAlias = string2;
        this.helper = new SessionFactoryHelper(sessionFactoryImplementor);
        this.createAliasCriteriaMap();
        this.createAssociationPathCriteriaMap();
        this.createCriteriaEntityNameMap();
        this.createCriteriaSQLAliasMap();
    }

    public String generateSQLAlias() {
        return StringHelper.generateAlias("this", this.aliasCount) + '_';
    }

    public String getRootSQLALias() {
        return this.rootSQLAlias;
    }

    private Criteria getAliasedCriteria(String string) {
        return (Criteria)this.aliasCriteriaMap.get(string);
    }

    public boolean isJoin(String string) {
        return this.associationPathCriteriaMap.containsKey(string);
    }

    public JoinType getJoinType(String string) {
        JoinType joinType = this.associationPathJoinTypesMap.get(string);
        return joinType == null ? JoinType.INNER_JOIN : joinType;
    }

    public Criteria getCriteria(String string) {
        return (Criteria)this.associationPathCriteriaMap.get(string);
    }

    public Set getQuerySpaces() {
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        for (CriteriaInfoProvider criteriaInfoProvider : this.criteriaInfoMap.values()) {
            hashSet.addAll(Arrays.asList(criteriaInfoProvider.getSpaces()));
        }
        return hashSet;
    }

    private void createAliasCriteriaMap() {
        this.aliasCriteriaMap.put(this.rootCriteria.getAlias(), this.rootCriteria);
        Iterator iterator = this.rootCriteria.iterateSubcriteria();
        while (iterator.hasNext()) {
            Criteria criteria;
            Criteria criteria2 = (Criteria)iterator.next();
            if (criteria2.getAlias() == null || (criteria = this.aliasCriteriaMap.put(criteria2.getAlias(), criteria2)) == null) continue;
            throw new QueryException("duplicate alias: " + criteria2.getAlias());
        }
    }

    private void createAssociationPathCriteriaMap() {
        Iterator iterator = this.rootCriteria.iterateSubcriteria();
        while (iterator.hasNext()) {
            CriteriaImpl.Subcriteria subcriteria = (CriteriaImpl.Subcriteria)iterator.next();
            String string = this.getWholeAssociationPath(subcriteria);
            Object object = this.associationPathCriteriaMap.put(string, subcriteria);
            if (object != null) {
                throw new QueryException("duplicate association path: " + string);
            }
            JoinType joinType = subcriteria.getJoinType();
            object = this.associationPathJoinTypesMap.put(string, joinType);
            if (object != null) {
                throw new QueryException("duplicate association path: " + string);
            }
            if (subcriteria.getWithClause() == null) continue;
            this.withClauseMap.put(string, subcriteria.getWithClause());
        }
    }

    private String getWholeAssociationPath(CriteriaImpl.Subcriteria subcriteria) {
        String string;
        String string2 = subcriteria.getPath();
        Criteria criteria = null;
        if (string2.indexOf(46) > 0 && !(string = StringHelper.root(string2)).equals(subcriteria.getAlias())) {
            criteria = (Criteria)this.aliasCriteriaMap.get(string);
        }
        if (criteria == null) {
            criteria = subcriteria.getParent();
        } else {
            string2 = StringHelper.unroot(string2);
        }
        if (criteria.equals(this.rootCriteria)) {
            return string2;
        }
        return this.getWholeAssociationPath((CriteriaImpl.Subcriteria)criteria) + '.' + string2;
    }

    private void createCriteriaEntityNameMap() {
        EntityCriteriaInfoProvider entityCriteriaInfoProvider = new EntityCriteriaInfoProvider((Queryable)this.sessionFactory.getEntityPersister(this.rootEntityName));
        this.criteriaInfoMap.put(this.rootCriteria, entityCriteriaInfoProvider);
        this.nameCriteriaInfoMap.put(entityCriteriaInfoProvider.getName(), entityCriteriaInfoProvider);
        for (Map.Entry entry : this.associationPathCriteriaMap.entrySet()) {
            CriteriaInfoProvider criteriaInfoProvider = this.getPathInfo((String)entry.getKey());
            this.criteriaInfoMap.put(entry.getValue(), criteriaInfoProvider);
            this.nameCriteriaInfoMap.put(criteriaInfoProvider.getName(), criteriaInfoProvider);
        }
    }

    private CriteriaInfoProvider getPathInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        CriteriaInfoProvider criteriaInfoProvider = (CriteriaInfoProvider)this.nameCriteriaInfoMap.get(this.rootEntityName);
        while (stringTokenizer.hasMoreTokens()) {
            Type type = criteriaInfoProvider.getType(string2 = string2 + stringTokenizer.nextToken());
            if (type.isAssociationType()) {
                Type type2;
                AssociationType associationType = (AssociationType)type;
                CollectionType collectionType = type.isCollectionType() ? (CollectionType)type : null;
                Type type3 = type2 = collectionType != null ? collectionType.getElementType(this.sessionFactory) : null;
                criteriaInfoProvider = collectionType != null && type2.isComponentType() ? new ComponentCollectionCriteriaInfoProvider(this.helper.getCollectionPersister(collectionType.getRole())) : (collectionType != null && !type2.isEntityType() ? new ScalarCollectionCriteriaInfoProvider(this.helper, collectionType.getRole()) : new EntityCriteriaInfoProvider((Queryable)this.sessionFactory.getEntityPersister(associationType.getAssociatedEntityName(this.sessionFactory))));
                string2 = "";
                continue;
            }
            if (type.isComponentType()) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new QueryException("Criteria objects cannot be created directly on components.  Create a criteria on owning entity and use a dotted property to access component property: " + string);
                }
                string2 = string2 + '.';
                continue;
            }
            throw new QueryException("not an association: " + string2);
        }
        return criteriaInfoProvider;
    }

    public int getSQLAliasCount() {
        return this.criteriaSQLAliasMap.size();
    }

    private void createCriteriaSQLAliasMap() {
        int n = 0;
        for (Map.Entry entry : this.criteriaInfoMap.entrySet()) {
            Criteria criteria = (Criteria)entry.getKey();
            String string = criteria.getAlias();
            if (string == null) {
                string = ((CriteriaInfoProvider)entry.getValue()).getName();
            }
            this.criteriaSQLAliasMap.put(criteria, StringHelper.generateAlias(string, n++));
        }
        this.criteriaSQLAliasMap.put(this.rootCriteria, this.rootSQLAlias);
    }

    public CriteriaImpl getRootCriteria() {
        return this.rootCriteria;
    }

    public QueryParameters getQueryParameters() {
        Serializable[] serializableArray;
        Object object;
        Object object2;
        LockOptions lockOptions = new LockOptions();
        RowSelection rowSelection = new RowSelection();
        rowSelection.setFirstRow(this.rootCriteria.getFirstResult());
        rowSelection.setMaxRows(this.rootCriteria.getMaxResults());
        rowSelection.setTimeout(this.rootCriteria.getTimeout());
        rowSelection.setFetchSize(this.rootCriteria.getFetchSize());
        for (Map.Entry object32 : this.rootCriteria.getLockModes().entrySet()) {
            object2 = this.getAliasedCriteria((String)object32.getKey());
            lockOptions.setAliasSpecificLockMode(this.getSQLAlias((Criteria)object2), (LockMode)((Object)object32.getValue()));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object2 = new ArrayList();
        Iterator iterator = this.rootCriteria.iterateSubcriteria();
        while (iterator.hasNext()) {
            object = (Object[])iterator.next();
            serializableArray = ((CriteriaImpl.Subcriteria)object).getLockMode();
            if (serializableArray != null) {
                lockOptions.setAliasSpecificLockMode(this.getSQLAlias((Criteria)object), (LockMode)serializableArray);
            }
            if (((CriteriaImpl.Subcriteria)object).getWithClause() == null) continue;
            TypedValue[] i = ((CriteriaImpl.Subcriteria)object).getWithClause().getTypedValues((Criteria)object, this);
            for (int j = 0; j < i.length; ++j) {
                arrayList.add(i[j].getValue());
                object2.add(i[j].getType());
            }
        }
        iterator = this.rootCriteria.iterateExpressionEntries();
        while (iterator.hasNext()) {
            object = (CriteriaImpl.CriterionEntry)iterator.next();
            serializableArray = ((CriteriaImpl.CriterionEntry)object).getCriterion().getTypedValues(((CriteriaImpl.CriterionEntry)object).getCriteria(), this);
            for (int i = 0; i < serializableArray.length; ++i) {
                arrayList.add(((TypedValue)serializableArray[i]).getValue());
                object2.add(((TypedValue)serializableArray[i]).getType());
            }
        }
        object = arrayList.toArray();
        serializableArray = ArrayHelper.toTypeArray((Collection)object2);
        return new QueryParameters((Type[])serializableArray, (Object[])object, lockOptions, rowSelection, this.rootCriteria.isReadOnlyInitialized(), this.rootCriteria.isReadOnlyInitialized() ? this.rootCriteria.isReadOnly() : false, this.rootCriteria.getCacheable(), this.rootCriteria.getCacheRegion(), this.rootCriteria.getComment(), this.rootCriteria.isLookupByNaturalKey(), this.rootCriteria.getResultTransformer());
    }

    public boolean hasProjection() {
        return this.rootCriteria.getProjection() != null;
    }

    public String getGroupBy() {
        if (this.rootCriteria.getProjection().isGrouped()) {
            return this.rootCriteria.getProjection().toGroupSqlString(this.rootCriteria.getProjectionCriteria(), this);
        }
        return "";
    }

    public String getSelect() {
        return this.rootCriteria.getProjection().toSqlString(this.rootCriteria.getProjectionCriteria(), 0, this);
    }

    Type getResultType(Criteria criteria) {
        return this.getFactory().getTypeResolver().getTypeFactory().manyToOne(this.getEntityName(criteria));
    }

    public Type[] getProjectedTypes() {
        return this.rootCriteria.getProjection().getTypes(this.rootCriteria, this);
    }

    public String[] getProjectedColumnAliases() {
        return this.rootCriteria.getProjection() instanceof EnhancedProjection ? ((EnhancedProjection)this.rootCriteria.getProjection()).getColumnAliases(0, this.rootCriteria, this) : this.rootCriteria.getProjection().getColumnAliases(0);
    }

    public String[] getProjectedAliases() {
        return this.rootCriteria.getProjection().getAliases();
    }

    public String getWhereCondition() {
        StringBuilder stringBuilder = new StringBuilder(30);
        Iterator iterator = this.rootCriteria.iterateExpressionEntries();
        while (iterator.hasNext()) {
            CriteriaImpl.CriterionEntry criterionEntry = (CriteriaImpl.CriterionEntry)iterator.next();
            String string = criterionEntry.getCriterion().toSqlString(criterionEntry.getCriteria(), this);
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" and ");
        }
        return stringBuilder.toString();
    }

    public String getOrderBy() {
        StringBuilder stringBuilder = new StringBuilder(30);
        Iterator iterator = this.rootCriteria.iterateOrderings();
        while (iterator.hasNext()) {
            CriteriaImpl.OrderEntry orderEntry = (CriteriaImpl.OrderEntry)iterator.next();
            stringBuilder.append(orderEntry.getOrder().toSqlString(orderEntry.getCriteria(), this));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sessionFactory;
    }

    public String getSQLAlias(Criteria criteria) {
        return (String)this.criteriaSQLAliasMap.get(criteria);
    }

    public String getEntityName(Criteria criteria) {
        CriteriaInfoProvider criteriaInfoProvider = (CriteriaInfoProvider)this.criteriaInfoMap.get(criteria);
        return criteriaInfoProvider != null ? criteriaInfoProvider.getName() : null;
    }

    public String getColumn(Criteria criteria, String string) {
        String[] stringArray = this.getColumns(string, criteria);
        if (stringArray.length != 1) {
            throw new QueryException("property does not map to a single column: " + string);
        }
        return stringArray[0];
    }

    public String[] getColumnsUsingProjection(Criteria criteria, String string) throws HibernateException {
        Projection projection = this.rootCriteria.getProjection();
        String[] stringArray = null;
        if (projection != null) {
            String[] stringArray2 = stringArray = projection instanceof EnhancedProjection ? ((EnhancedProjection)projection).getColumnAliases(string, 0, this.rootCriteria, this) : projection.getColumnAliases(string, 0);
        }
        if (stringArray == null) {
            try {
                return this.getColumns(string, criteria);
            }
            catch (HibernateException hibernateException) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getColumnsUsingProjection(criteria, string);
                }
                throw hibernateException;
            }
        }
        return stringArray;
    }

    public String[] getIdentifierColumns(Criteria criteria) {
        String[] stringArray = ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(criteria)))).getIdentifierColumnNames();
        return StringHelper.qualify(this.getSQLAlias(criteria), stringArray);
    }

    public Type getIdentifierType(Criteria criteria) {
        return ((Loadable)((Object)this.getPropertyMapping(this.getEntityName(criteria)))).getIdentifierType();
    }

    public TypedValue getTypedIdentifierValue(Criteria criteria, Object object) {
        Loadable loadable = (Loadable)((Object)this.getPropertyMapping(this.getEntityName(criteria)));
        return new TypedValue(loadable.getIdentifierType(), object, EntityMode.POJO);
    }

    public String[] getColumns(String string, Criteria criteria) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(criteria, string)).toColumns(this.getSQLAlias(criteria, string), this.getPropertyName(string));
    }

    public String[] findColumns(String string, Criteria criteria) throws HibernateException {
        try {
            return this.getColumns(string, criteria);
        }
        catch (HibernateException hibernateException) {
            if (this.outerQueryTranslator != null) {
                return this.outerQueryTranslator.findColumns(string, criteria);
            }
            throw hibernateException;
        }
    }

    public Type getTypeUsingProjection(Criteria criteria, String string) throws HibernateException {
        Type[] typeArray;
        Projection projection = this.rootCriteria.getProjection();
        Type[] typeArray2 = typeArray = projection == null ? null : projection.getTypes(string, criteria, this);
        if (typeArray == null) {
            try {
                return this.getType(criteria, string);
            }
            catch (HibernateException hibernateException) {
                if (this.outerQueryTranslator != null) {
                    return this.outerQueryTranslator.getType(criteria, string);
                }
                throw hibernateException;
            }
        }
        if (typeArray.length != 1) {
            throw new QueryException("not a single-length projection: " + string);
        }
        return typeArray[0];
    }

    public Type getType(Criteria criteria, String string) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(criteria, string)).toType(this.getPropertyName(string));
    }

    public TypedValue getTypedValue(Criteria criteria, String string, Object object) throws HibernateException {
        Class clazz;
        Queryable queryable;
        if (object instanceof Class && (queryable = SessionFactoryHelper.findQueryableUsingImports(this.sessionFactory, (clazz = (Class)object).getName())) != null) {
            Type type = queryable.getDiscriminatorType();
            String string2 = queryable.getDiscriminatorSQLValue();
            if (string2 != null && string2.length() > 2 && string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!(type instanceof StringRepresentableType)) {
                throw new QueryException("Unsupported discriminator type " + type);
            }
            StringRepresentableType stringRepresentableType = (StringRepresentableType)((Object)type);
            object = stringRepresentableType.fromStringValue(string2);
            return new TypedValue(type, object, EntityMode.POJO);
        }
        return new TypedValue(this.getTypeUsingProjection(criteria, string), object, EntityMode.POJO);
    }

    private PropertyMapping getPropertyMapping(String string) throws MappingException {
        CriteriaInfoProvider criteriaInfoProvider = (CriteriaInfoProvider)this.nameCriteriaInfoMap.get(string);
        if (criteriaInfoProvider == null) {
            throw new HibernateException("Unknown entity: " + string);
        }
        return criteriaInfoProvider.getPropertyMapping();
    }

    public String getEntityName(Criteria criteria, String string) {
        String string2;
        Criteria criteria2;
        if (string.indexOf(46) > 0 && (criteria2 = this.getAliasedCriteria(string2 = StringHelper.root(string))) != null) {
            return this.getEntityName(criteria2);
        }
        return this.getEntityName(criteria);
    }

    public String getSQLAlias(Criteria criteria, String string) {
        String string2;
        Criteria criteria2;
        if (string.indexOf(46) > 0 && (criteria2 = this.getAliasedCriteria(string2 = StringHelper.root(string))) != null) {
            return this.getSQLAlias(criteria2);
        }
        return this.getSQLAlias(criteria);
    }

    public String getPropertyName(String string) {
        String string2;
        Criteria criteria;
        if (string.indexOf(46) > 0 && (criteria = this.getAliasedCriteria(string2 = StringHelper.root(string))) != null) {
            return string.substring(string2.length() + 1);
        }
        return string;
    }

    public String getWithClause(String string) {
        Criterion criterion = (Criterion)this.withClauseMap.get(string);
        return criterion == null ? null : criterion.toSqlString(this.getCriteria(string), this);
    }

    public boolean hasRestriction(String string) {
        CriteriaImpl.Subcriteria subcriteria = (CriteriaImpl.Subcriteria)this.getCriteria(string);
        return subcriteria == null ? false : subcriteria.hasRestriction();
    }
}

