/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaLoader
extends OuterJoinLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final boolean[] includeInResultRow;
    private final int resultRowLength;

    public CriteriaLoader(OuterJoinLoadable outerJoinLoadable, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, LoadQueryInfluencers loadQueryInfluencers) throws HibernateException {
        super(sessionFactoryImplementor, loadQueryInfluencers);
        this.translator = new CriteriaQueryTranslator(sessionFactoryImplementor, criteriaImpl, string, "this_");
        this.querySpaces = this.translator.getQuerySpaces();
        CriteriaJoinWalker criteriaJoinWalker = new CriteriaJoinWalker(outerJoinLoadable, this.translator, sessionFactoryImplementor, criteriaImpl, string, loadQueryInfluencers);
        this.initFromWalker(criteriaJoinWalker);
        this.userAliases = criteriaJoinWalker.getUserAliases();
        this.resultTypes = criteriaJoinWalker.getResultTypes();
        this.includeInResultRow = criteriaJoinWalker.includeInResultRow();
        this.resultRowLength = ArrayHelper.countTrue(this.includeInResultRow);
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor sessionImplementor, ScrollMode scrollMode) throws HibernateException {
        QueryParameters queryParameters = this.translator.getQueryParameters();
        queryParameters.setScrollMode(scrollMode);
        return this.scroll(queryParameters, this.resultTypes, null, sessionImplementor);
    }

    public List list(SessionImplementor sessionImplementor) throws HibernateException {
        return this.list(sessionImplementor, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    @Override
    protected String[] getResultRowAliases() {
        return this.userAliases;
    }

    @Override
    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        return this.translator.getRootCriteria().getResultTransformer();
    }

    @Override
    protected boolean areResultSetRowsTransformedImmediately() {
        return true;
    }

    @Override
    protected boolean[] includeInResultRow() {
        return this.includeInResultRow;
    }

    @Override
    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return this.resolveResultTransformer(resultTransformer).transformTuple(this.getResultRow(objectArray, resultSet, sessionImplementor), this.getResultRowAliases());
    }

    @Override
    protected Object[] getResultRow(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray2;
        if (this.translator.hasProjection()) {
            Type[] typeArray = this.translator.getProjectedTypes();
            objectArray2 = new Object[typeArray.length];
            String[] stringArray = this.translator.getProjectedColumnAliases();
            int n = 0;
            for (int i = 0; i < objectArray2.length; ++i) {
                int n2 = typeArray[i].getColumnSpan(sessionImplementor.getFactory());
                if (n2 > 1) {
                    String[] stringArray2 = ArrayHelper.slice(stringArray, n, n2);
                    objectArray2[i] = typeArray[i].nullSafeGet(resultSet, stringArray2, sessionImplementor, null);
                } else {
                    objectArray2[i] = typeArray[i].nullSafeGet(resultSet, stringArray[n], sessionImplementor, null);
                }
                n += n2;
            }
        } else {
            objectArray2 = this.toResultRow(objectArray);
        }
        return objectArray2;
    }

    private Object[] toResultRow(Object[] objectArray) {
        if (this.resultRowLength == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[this.resultRowLength];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.includeInResultRow[i]) continue;
            objectArray2[n++] = objectArray[i];
        }
        return objectArray2;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    protected String applyLocks(String string, QueryParameters queryParameters, Dialect dialect, List<Loader.AfterLoadAction> list) throws QueryException {
        LockOptions lockOptions = queryParameters.getLockOptions();
        if (lockOptions == null || lockOptions.getLockMode() == LockMode.NONE && lockOptions.getAliasLockCount() == 0) {
            return string;
        }
        if (dialect.useFollowOnLocking()) {
            LOG.usingFollowOnLocking();
            LockMode lockMode = this.determineFollowOnLockMode(lockOptions);
            final LockOptions lockOptions2 = new LockOptions(lockMode);
            lockOptions2.setTimeOut(lockOptions.getTimeOut());
            lockOptions2.setScope(lockOptions.getScope());
            list.add(new Loader.AfterLoadAction(){

                public void afterLoad(SessionImplementor sessionImplementor, Object object, Loadable loadable) {
                    ((Session)((Object)sessionImplementor)).buildLockRequest(lockOptions2).lock(loadable.getEntityName(), object);
                }
            });
            queryParameters.setLockOptions(new LockOptions());
            return string;
        }
        LockOptions lockOptions3 = new LockOptions(lockOptions.getLockMode());
        lockOptions3.setScope(lockOptions.getScope());
        lockOptions3.setTimeOut(lockOptions.getTimeOut());
        HashMap<String, String[]> hashMap = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        String[] stringArray = this.getAliases();
        for (int i = 0; i < stringArray.length; ++i) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(stringArray[i]);
            if (lockMode == null) continue;
            Lockable lockable = (Lockable)((Object)this.getEntityPersisters()[i]);
            String string2 = lockable.getRootTableAlias(stringArray[i]);
            lockOptions3.setAliasSpecificLockMode(string2, lockMode);
            if (hashMap == null) continue;
            hashMap.put(string2, lockable.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(string, lockOptions3, hashMap);
    }

    @Override
    protected LockMode determineFollowOnLockMode(LockOptions lockOptions) {
        LockMode lockMode = lockOptions.findGreatestLockMode();
        if (lockOptions.getAliasLockCount() > 1) {
            LOG.aliasSpecificLockingWithFollowOnLocking(lockMode);
        }
        return lockMode;
    }

    @Override
    protected LockMode[] getLockModes(LockOptions lockOptions) {
        String[] stringArray = this.getAliases();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        LockMode[] lockModeArray = new LockMode[n];
        for (int i = 0; i < n; ++i) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(stringArray[i]);
            lockModeArray[i] = lockMode == null ? lockOptions.getLockMode() : lockMode;
        }
        return lockModeArray;
    }

    @Override
    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    @Override
    protected List getResultList(List list, ResultTransformer resultTransformer) {
        return this.resolveResultTransformer(resultTransformer).transformList(list);
    }
}

