/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class CriteriaJoinWalker
extends AbstractEntityJoinWalker {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final boolean[] includeInResultRow;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();
    private final List resultTypeList = new ArrayList();
    private final List includeInResultRowList = new ArrayList();

    public Type[] getResultTypes() {
        return this.resultTypes;
    }

    public String[] getUserAliases() {
        return this.userAliases;
    }

    public boolean[] includeInResultRow() {
        return this.includeInResultRow;
    }

    public CriteriaJoinWalker(OuterJoinLoadable outerJoinLoadable, CriteriaQueryTranslator criteriaQueryTranslator, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, LoadQueryInfluencers loadQueryInfluencers) {
        this(outerJoinLoadable, criteriaQueryTranslator, sessionFactoryImplementor, criteriaImpl, string, loadQueryInfluencers, null);
    }

    public CriteriaJoinWalker(OuterJoinLoadable outerJoinLoadable, CriteriaQueryTranslator criteriaQueryTranslator, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, LoadQueryInfluencers loadQueryInfluencers, String string2) {
        super(outerJoinLoadable, sessionFactoryImplementor, loadQueryInfluencers, string2);
        this.translator = criteriaQueryTranslator;
        this.querySpaces = criteriaQueryTranslator.getQuerySpaces();
        if (criteriaQueryTranslator.hasProjection()) {
            this.initProjection(criteriaQueryTranslator.getSelect(), criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), criteriaQueryTranslator.getGroupBy(), LockOptions.NONE);
            this.resultTypes = criteriaQueryTranslator.getProjectedTypes();
            this.userAliases = criteriaQueryTranslator.getProjectedAliases();
            this.includeInResultRow = new boolean[this.resultTypes.length];
            Arrays.fill(this.includeInResultRow, true);
        } else {
            this.initAll(criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), LockOptions.NONE);
            this.userAliasList.add(criteriaImpl.getAlias());
            this.resultTypeList.add(criteriaQueryTranslator.getResultType(criteriaImpl));
            this.includeInResultRowList.add(true);
            this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
            this.resultTypes = ArrayHelper.toTypeArray(this.resultTypeList);
            this.includeInResultRow = ArrayHelper.toBooleanArray(this.includeInResultRowList);
        }
    }

    protected JoinType getJoinType(OuterJoinLoadable outerJoinLoadable, PropertyPath propertyPath, int n, AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle, String string, String[] stringArray, boolean bl, int n2) throws MappingException {
        JoinType joinType;
        if (this.translator.isJoin(propertyPath.getFullPath())) {
            joinType = this.translator.getJoinType(propertyPath.getFullPath());
        } else if (this.translator.hasProjection()) {
            joinType = JoinType.NONE;
        } else {
            FetchMode fetchMode2 = this.translator.getRootCriteria().getFetchMode(propertyPath.getFullPath());
            if (CriteriaJoinWalker.isDefaultFetchMode(fetchMode2)) {
                joinType = outerJoinLoadable != null ? (this.isJoinFetchEnabledByProfile(outerJoinLoadable, propertyPath, n) ? (this.isDuplicateAssociation(string, stringArray, associationType) ? JoinType.NONE : (this.isTooDeep(n2) || associationType.isCollectionType() && this.isTooManyCollections() ? JoinType.NONE : this.getJoinType(bl, n2))) : super.getJoinType(outerJoinLoadable, propertyPath, n, associationType, fetchMode, cascadeStyle, string, stringArray, bl, n2)) : super.getJoinType(associationType, fetchMode, propertyPath, string, stringArray, bl, n2, cascadeStyle);
            } else if (fetchMode2 == FetchMode.JOIN) {
                this.isDuplicateAssociation(string, stringArray, associationType);
                joinType = this.getJoinType(bl, n2);
            } else {
                joinType = JoinType.NONE;
            }
        }
        return joinType;
    }

    protected JoinType getJoinType(AssociationType associationType, FetchMode fetchMode, PropertyPath propertyPath, String string, String[] stringArray, boolean bl, int n, CascadeStyle cascadeStyle) throws MappingException {
        return this.getJoinType(null, propertyPath, -1, associationType, fetchMode, cascadeStyle, string, stringArray, bl, n);
    }

    private static boolean isDefaultFetchMode(FetchMode fetchMode) {
        return fetchMode == null || fetchMode == FetchMode.DEFAULT;
    }

    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getLoadQueryInfluencers().getEnabledFilters());
    }

    protected String generateTableAlias(int n, PropertyPath propertyPath, Joinable joinable) {
        Object object;
        Object object2;
        boolean bl = joinable.consumesEntityAlias();
        if (!bl && joinable.isCollection() && ((object2 = (object = (CollectionPersister)((Object)joinable)).getElementType()).isComponentType() || !object2.isEntityType())) {
            bl = true;
        }
        object = null;
        if (bl) {
            object2 = this.translator.getCriteria(propertyPath.getFullPath());
            Object object3 = object = object2 == null ? null : this.translator.getSQLAlias((Criteria)object2);
            if (joinable.consumesEntityAlias() && !this.translator.hasProjection()) {
                this.includeInResultRowList.add(object2 != null && object2.getAlias() != null);
                if (object != null && object2.getAlias() != null) {
                    this.userAliasList.add(object2.getAlias());
                    this.resultTypeList.add(this.translator.getResultType((Criteria)object2));
                }
            }
        }
        if (object == null) {
            object = super.generateTableAlias(n + this.translator.getSQLAliasCount(), propertyPath, joinable);
        }
        return object;
    }

    protected String generateRootAlias(String string) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public String getComment() {
        return "criteria query";
    }

    protected String getWithClause(PropertyPath propertyPath) {
        return this.translator.getWithClause(propertyPath.getFullPath());
    }

    protected boolean hasRestriction(PropertyPath propertyPath) {
        return this.translator.hasRestriction(propertyPath.getFullPath());
    }
}

